/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.disk;

import java.io.IOException;
import org.apache.paimon.compression.BlockCompressionFactory;
import org.apache.paimon.compression.BlockCompressor;
import org.apache.paimon.data.AbstractPagedOutputView;
import org.apache.paimon.disk.BufferFileWriter;
import org.apache.paimon.disk.FileIOChannel;
import org.apache.paimon.memory.Buffer;
import org.apache.paimon.memory.MemorySegment;

public final class ChannelWriterOutputView
extends AbstractPagedOutputView {
    private final MemorySegment compressedBuffer;
    private final BlockCompressor compressor;
    private final BufferFileWriter writer;
    private int blockCount;
    private long numBytes;
    private long numCompressedBytes;
    private long writeBytes;

    public ChannelWriterOutputView(BufferFileWriter writer, BlockCompressionFactory compressionCodecFactory, int compressionBlockSize) {
        super(MemorySegment.wrap(new byte[compressionBlockSize]), compressionBlockSize);
        this.compressor = compressionCodecFactory.getCompressor();
        this.compressedBuffer = MemorySegment.wrap(new byte[this.compressor.getMaxCompressedSize(compressionBlockSize)]);
        this.writer = writer;
    }

    public FileIOChannel getChannel() {
        return this.writer;
    }

    public int close() throws IOException {
        if (!this.writer.isClosed()) {
            int currentPositionInSegment = this.getCurrentPositionInSegment();
            this.writeCompressed(this.currentSegment, currentPositionInSegment);
            this.clear();
            this.writeBytes = this.writer.getSize();
            this.writer.close();
        }
        return -1;
    }

    public void closeAndDelete() throws IOException {
        try {
            this.close();
        }
        finally {
            this.writer.deleteChannel();
        }
    }

    @Override
    protected MemorySegment nextSegment(MemorySegment current, int positionInCurrent) throws IOException {
        this.writeCompressed(current, positionInCurrent);
        return current;
    }

    private void writeCompressed(MemorySegment current, int size) throws IOException {
        int compressedLen = this.compressor.compress(current.getArray(), 0, size, this.compressedBuffer.getArray(), 0);
        this.writer.writeBlock(Buffer.create(this.compressedBuffer, compressedLen));
        ++this.blockCount;
        this.numBytes += (long)size;
        this.numCompressedBytes += (long)compressedLen;
    }

    public long getNumBytes() {
        return this.numBytes;
    }

    public long getNumCompressedBytes() {
        return this.numCompressedBytes;
    }

    public long getWriteBytes() {
        return this.writeBytes;
    }

    public int getBlockCount() {
        return this.blockCount;
    }
}

