/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.deletionvectors;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.paimon.deletionvectors.BitmapDeletionVector;
import org.apache.paimon.deletionvectors.DeletionVectorsMaintainer;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.SeekableInputStream;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.table.source.DeletionFile;

public interface DeletionVector {
    public void delete(long var1);

    default public boolean checkedDelete(long position) {
        if (this.isDeleted(position)) {
            return false;
        }
        this.delete(position);
        return true;
    }

    public boolean isDeleted(long var1);

    public boolean isEmpty();

    public byte[] serializeToBytes();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DeletionVector deserializeFromBytes(byte[] bytes) {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(bytes);){
            int magicNum;
            Throwable throwable;
            DataInputStream dis;
            block25: {
                DeletionVector deletionVector;
                block26: {
                    dis = new DataInputStream(bis);
                    throwable = null;
                    magicNum = dis.readInt();
                    if (magicNum != 1581511376) break block25;
                    deletionVector = BitmapDeletionVector.deserializeFromDataInput(dis);
                    if (dis == null) return deletionVector;
                    if (throwable == null) break block26;
                    try {
                        dis.close();
                        return deletionVector;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                        return deletionVector;
                    }
                }
                dis.close();
                return deletionVector;
            }
            try {
                try {
                    throw new RuntimeException("Invalid magic number: " + magicNum);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable throwable4) {
                if (dis == null) throw throwable4;
                if (throwable == null) {
                    dis.close();
                    throw throwable4;
                }
                try {
                    dis.close();
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    throwable.addSuppressed(throwable5);
                    throw throwable4;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to deserialize deletion vector", e);
        }
    }

    public static DeletionVector read(FileIO fileIO, DeletionFile deletionFile) throws IOException {
        Path path = new Path(deletionFile.path());
        Throwable throwable = null;
        try (SeekableInputStream input = fileIO.newInputStream(path);){
            input.seek(deletionFile.offset());
            DataInputStream dis = new DataInputStream(input);
            int actualLength = dis.readInt();
            if ((long)actualLength != deletionFile.length()) {
                throw new RuntimeException("Size not match, actual size: " + actualLength + ", expert size: " + deletionFile.length() + ", file path: " + path);
            }
            int magicNum = dis.readInt();
            if (magicNum == 1581511376) {
                DeletionVector deletionVector = BitmapDeletionVector.deserializeFromDataInput(dis);
                return deletionVector;
            }
            try {
                throw new RuntimeException("Invalid magic number: " + magicNum);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public static Factory emptyFactory() {
        return fileName -> Optional.empty();
    }

    public static Factory factory(@Nullable DeletionVectorsMaintainer dvMaintainer) {
        if (dvMaintainer == null) {
            return DeletionVector.emptyFactory();
        }
        return dvMaintainer::deletionVectorOf;
    }

    public static Factory factory(FileIO fileIO, List<DataFileMeta> files, @Nullable List<DeletionFile> deletionFiles) {
        if (deletionFiles == null) {
            return DeletionVector.emptyFactory();
        }
        HashMap<String, DeletionFile> fileToDeletion = new HashMap<String, DeletionFile>();
        for (int i = 0; i < files.size(); ++i) {
            DeletionFile deletionFile = deletionFiles.get(i);
            if (deletionFile == null) continue;
            fileToDeletion.put(files.get(i).fileName(), deletionFile);
        }
        return fileName -> {
            DeletionFile deletionFile = (DeletionFile)fileToDeletion.get(fileName);
            if (deletionFile == null) {
                return Optional.empty();
            }
            return Optional.of(DeletionVector.read(fileIO, deletionFile));
        };
    }

    public static interface Factory {
        public Optional<DeletionVector> create(String var1) throws IOException;
    }
}

