/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

public class FixLenByteArrayOutputStream {
    private byte[] buf;
    private int count;

    public void setBuffer(byte[] buffer) {
        this.buf = buffer;
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public int write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len - b.length > 0) {
            throw new IndexOutOfBoundsException();
        }
        int writeLen = Math.min(len, this.buf.length - this.count);
        System.arraycopy(b, off, this.buf, this.count, writeLen);
        this.count += writeLen;
        return writeLen;
    }

    public int getCount() {
        return this.count;
    }

    public int write(byte b) {
        if (this.count < this.buf.length) {
            this.buf[this.count] = b;
            ++this.count;
            return 1;
        }
        return 0;
    }

    public void setCount(int count) {
        this.count = count;
    }
}

