/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.io.Closeable;
import java.io.IOException;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.io.PageFileInput;
import org.apache.paimon.io.cache.CacheCallback;
import org.apache.paimon.io.cache.CacheKey;
import org.apache.paimon.io.cache.CacheManager;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.utils.BloomFilter;
import org.apache.paimon.utils.Preconditions;

public class FileBasedBloomFilter
implements Closeable {
    private final PageFileInput input;
    private final CacheManager cacheManager;
    private final BloomFilter filter;
    private final long readOffset;
    private final int readLength;
    private final CacheKey cacheKey;
    private int accessCount;

    public FileBasedBloomFilter(PageFileInput input, CacheManager cacheManager, long expectedEntries, long readOffset, int readLength) {
        this.input = input;
        this.cacheManager = cacheManager;
        Preconditions.checkArgument(expectedEntries >= 0L);
        this.filter = new BloomFilter(expectedEntries, readLength);
        this.readOffset = readOffset;
        this.readLength = readLength;
        this.accessCount = 0;
        this.cacheKey = CacheKey.forPosition(input.file(), readOffset, readLength, true);
    }

    public boolean testHash(int hash) {
        ++this.accessCount;
        if (this.accessCount == 10 || this.filter.getMemorySegment() == null) {
            MemorySegment segment = this.cacheManager.getPage(this.cacheKey, key -> this.input.readPosition(this.readOffset, this.readLength), new BloomFilterCallBack(this.filter));
            this.filter.setMemorySegment(segment, 0);
            this.accessCount = 0;
        }
        return this.filter.testHash(hash);
    }

    @VisibleForTesting
    BloomFilter bloomFilter() {
        return this.filter;
    }

    @Override
    public void close() throws IOException {
        this.cacheManager.invalidPage(this.cacheKey);
    }

    private static class BloomFilterCallBack
    implements CacheCallback {
        private final BloomFilter bloomFilter;

        private BloomFilterCallBack(BloomFilter bloomFilter) {
            this.bloomFilter = bloomFilter;
        }

        @Override
        public void onRemoval(CacheKey key) {
            this.bloomFilter.unsetMemorySegment();
        }
    }
}

