/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.types;

import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.paimon.types.DataType;
import org.apache.paimon.utils.EncodingUtils;

@Public
public final class DataField
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIELD_FORMAT_WITH_DESCRIPTION = "%s %s '%s'";
    public static final String FIELD_FORMAT_NO_DESCRIPTION = "%s %s";
    private final int id;
    private final String name;
    private final DataType type;
    @Nullable
    private final String description;

    public DataField(int id, String name, DataType dataType) {
        this(id, name, dataType, null);
    }

    public DataField(int id, String name, DataType type, @Nullable String description) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.description = description;
    }

    public int id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public DataType type() {
        return this.type;
    }

    public DataField newId(int newid) {
        return new DataField(newid, this.name, this.type, this.description);
    }

    public DataField newName(String newName) {
        return new DataField(this.id, newName, this.type, this.description);
    }

    public DataField newType(DataType newType) {
        return new DataField(this.id, this.name, newType, this.description);
    }

    public DataField newDescription(String newDescription) {
        return new DataField(this.id, this.name, this.type, newDescription);
    }

    @Nullable
    public String description() {
        return this.description;
    }

    public DataField copy() {
        return new DataField(this.id, this.name, this.type.copy(), this.description);
    }

    public DataField copy(boolean isNullable) {
        return new DataField(this.id, this.name, this.type.copy(isNullable), this.description);
    }

    public String asSQLString() {
        return this.formatString(this.type.asSQLString());
    }

    private String formatString(String typeString) {
        if (this.description == null) {
            return String.format(FIELD_FORMAT_NO_DESCRIPTION, EncodingUtils.escapeIdentifier(this.name), typeString);
        }
        return String.format(FIELD_FORMAT_WITH_DESCRIPTION, EncodingUtils.escapeIdentifier(this.name), typeString, EncodingUtils.escapeSingleQuotes(this.description));
    }

    public void serializeJson(JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeNumberField("id", this.id());
        generator.writeStringField("name", this.name());
        generator.writeFieldName("type");
        this.type.serializeJson(generator);
        if (this.description() != null) {
            generator.writeStringField("description", this.description());
        }
        generator.writeEndObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataField field = (DataField)o;
        return Objects.equals(this.id, field.id) && Objects.equals(this.name, field.name) && Objects.equals(this.type, field.type) && Objects.equals(this.description, field.description);
    }

    public boolean equalsIgnoreFieldId(DataField other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return Objects.equals(this.name, other.name) && this.type.equalsIgnoreFieldId(other.type) && Objects.equals(this.description, other.description);
    }

    public boolean isPrunedFrom(DataField other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && this.type.isPrunedFrom(other.type) && Objects.equals(this.description, other.description);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.type, this.description);
    }

    public String toString() {
        return this.asSQLString();
    }

    public static boolean dataFieldEqualsIgnoreId(DataField dataField1, DataField dataField2) {
        if (dataField1 == dataField2) {
            return true;
        }
        if (dataField1 != null && dataField2 != null) {
            return Objects.equals(dataField1.name(), dataField2.name()) && Objects.equals(dataField1.type(), dataField2.type()) && Objects.equals(dataField1.description(), dataField2.description());
        }
        return false;
    }
}

