/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source.snapshot;

import javax.annotation.Nullable;
import org.apache.paimon.Snapshot;
import org.apache.paimon.table.source.ScanMode;
import org.apache.paimon.table.source.snapshot.ReadPlanStartingScanner;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.utils.SnapshotManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticFromTimestampStartingScanner
extends ReadPlanStartingScanner {
    private static final Logger LOG = LoggerFactory.getLogger(StaticFromTimestampStartingScanner.class);
    private final long startupMillis;

    public StaticFromTimestampStartingScanner(SnapshotManager snapshotManager, long startupMillis) {
        super(snapshotManager);
        this.startupMillis = startupMillis;
        Snapshot snapshot = StaticFromTimestampStartingScanner.timeTravelToTimestamp(snapshotManager, startupMillis);
        if (snapshot != null) {
            this.startingSnapshotId = snapshot.id();
        }
    }

    @Override
    public SnapshotReader configure(SnapshotReader snapshotReader) {
        if (this.startingSnapshotId == null) {
            LOG.debug("There is currently no snapshot earlier than or equal to timestamp[{}]", (Object)this.startupMillis);
            return null;
        }
        return snapshotReader.withMode(ScanMode.ALL).withSnapshot(this.startingSnapshotId);
    }

    @Nullable
    public static Snapshot timeTravelToTimestamp(SnapshotManager snapshotManager, long timestamp) {
        return snapshotManager.earlierOrEqualTimeMills(timestamp);
    }
}

