/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.object;

import java.util.HashSet;
import java.util.Map;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.manifest.ManifestCacheFilter;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.DelegatedFileStoreTable;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.object.ObjectRefresh;
import org.apache.paimon.table.sink.BatchWriteBuilder;
import org.apache.paimon.table.sink.StreamWriteBuilder;
import org.apache.paimon.table.sink.TableCommitImpl;
import org.apache.paimon.table.sink.TableWriteImpl;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Preconditions;

public interface ObjectTable
extends FileStoreTable {
    public static final RowType SCHEMA = RowType.builder().field("path", DataTypes.STRING().notNull()).field("parent_path", DataTypes.STRING().notNull()).field("name", DataTypes.STRING().notNull()).field("length", DataTypes.BIGINT().notNull()).field("mtime", DataTypes.TIMESTAMP_LTZ_MILLIS()).field("atime", DataTypes.TIMESTAMP_LTZ_MILLIS()).field("owner", DataTypes.STRING().nullable()).field("generation", DataTypes.INT().nullable()).field("content_type", DataTypes.STRING().nullable()).field("storage_class", DataTypes.STRING().nullable()).field("md5_hash", DataTypes.STRING().nullable()).field("metadata_mtime", DataTypes.TIMESTAMP_LTZ_MILLIS().nullable()).field("metadata", DataTypes.MAP(DataTypes.STRING(), DataTypes.STRING())).build().notNull();

    public String objectLocation();

    public FileStoreTable underlyingTable();

    public FileIO objectFileIO();

    public long refresh();

    @Override
    public ObjectTable copy(Map<String, String> var1);

    @Override
    public ObjectTable copy(TableSchema var1);

    @Override
    public ObjectTable copyWithoutTimeTravel(Map<String, String> var1);

    @Override
    public ObjectTable copyWithLatestSchema();

    @Override
    public ObjectTable switchToBranch(String var1);

    public static Builder builder() {
        return new Builder();
    }

    public static class ObjectTableImpl
    extends DelegatedFileStoreTable
    implements ObjectTable {
        private final FileIO objectFileIO;
        private final String objectLocation;

        public ObjectTableImpl(FileStoreTable underlyingTable, FileIO objectFileIO, String objectLocation) {
            super(underlyingTable);
            this.objectFileIO = objectFileIO;
            this.objectLocation = objectLocation;
        }

        @Override
        public BatchWriteBuilder newBatchWriteBuilder() {
            throw new UnsupportedOperationException("Object table does not support Write.");
        }

        @Override
        public StreamWriteBuilder newStreamWriteBuilder() {
            throw new UnsupportedOperationException("Object table does not support Write.");
        }

        @Override
        public TableWriteImpl<?> newWrite(String commitUser) {
            throw new UnsupportedOperationException("Object table does not support Write.");
        }

        @Override
        public TableWriteImpl<?> newWrite(String commitUser, ManifestCacheFilter manifestFilter) {
            throw new UnsupportedOperationException("Object table does not support Write.");
        }

        @Override
        public TableCommitImpl newCommit(String commitUser) {
            throw new UnsupportedOperationException("Object table does not support Commit.");
        }

        @Override
        public String objectLocation() {
            return this.objectLocation;
        }

        @Override
        public FileStoreTable underlyingTable() {
            return this.wrapped;
        }

        @Override
        public FileIO objectFileIO() {
            return this.objectFileIO;
        }

        @Override
        public long refresh() {
            try {
                return ObjectRefresh.refresh(this);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public ObjectTable copy(Map<String, String> dynamicOptions) {
            return new ObjectTableImpl((FileStoreTable)this.wrapped.copy((Map)dynamicOptions), this.objectFileIO, this.objectLocation);
        }

        @Override
        public ObjectTable copy(TableSchema newTableSchema) {
            return new ObjectTableImpl(this.wrapped.copy(newTableSchema), this.objectFileIO, this.objectLocation);
        }

        @Override
        public ObjectTable copyWithoutTimeTravel(Map<String, String> dynamicOptions) {
            return new ObjectTableImpl(this.wrapped.copyWithoutTimeTravel(dynamicOptions), this.objectFileIO, this.objectLocation);
        }

        @Override
        public ObjectTable copyWithLatestSchema() {
            return new ObjectTableImpl(this.wrapped.copyWithLatestSchema(), this.objectFileIO, this.objectLocation);
        }

        @Override
        public ObjectTable switchToBranch(String branchName) {
            return new ObjectTableImpl(this.wrapped.switchToBranch(branchName), this.objectFileIO, this.objectLocation);
        }
    }

    public static class Builder {
        private FileStoreTable underlyingTable;
        private FileIO objectFileIO;
        private String objectLocation;

        public Builder underlyingTable(FileStoreTable underlyingTable) {
            this.underlyingTable = underlyingTable;
            Preconditions.checkArgument(new HashSet<DataField>(SCHEMA.getFields()).containsAll(underlyingTable.rowType().getFields()), "Schema of Object Table should be %s, but is %s.", SCHEMA, underlyingTable.rowType());
            return this;
        }

        public Builder objectFileIO(FileIO objectFileIO) {
            this.objectFileIO = objectFileIO;
            return this;
        }

        public Builder objectLocation(String objectLocation) {
            this.objectLocation = objectLocation;
            return this;
        }

        public ObjectTable build() {
            return new ObjectTableImpl(this.underlyingTable, this.objectFileIO, this.objectLocation);
        }
    }
}

