/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.object;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericMap;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.FileStatus;
import org.apache.paimon.fs.Path;
import org.apache.paimon.table.object.ObjectTable;
import org.apache.paimon.table.sink.BatchTableCommit;
import org.apache.paimon.table.sink.BatchTableWrite;
import org.apache.paimon.table.sink.BatchWriteBuilder;

public class ObjectRefresh {
    public static long refresh(ObjectTable table) throws Exception {
        String location = table.objectLocation();
        ArrayList<FileStatus> fileCollector = new ArrayList<FileStatus>();
        ObjectRefresh.listAllFiles(table.objectFileIO(), new Path(location), fileCollector);
        BatchWriteBuilder writeBuilder = table.underlyingTable().newBatchWriteBuilder().withOverwrite();
        try (BatchTableWrite write = writeBuilder.newWrite();
             BatchTableCommit commit = writeBuilder.newCommit();){
            for (FileStatus file : fileCollector) {
                write.write(ObjectRefresh.toRow(file));
            }
            commit.commit(write.prepareCommit());
        }
        return fileCollector.size();
    }

    private static void listAllFiles(FileIO fileIO, Path directory, List<FileStatus> fileCollector) throws IOException {
        FileStatus[] files = fileIO.listStatus(directory);
        if (files == null) {
            return;
        }
        for (FileStatus file : files) {
            if (file.isDir()) {
                ObjectRefresh.listAllFiles(fileIO, file.getPath(), fileCollector);
                continue;
            }
            fileCollector.add(file);
        }
    }

    private static InternalRow toRow(FileStatus file) {
        return ObjectRefresh.toRow(file.getPath().toString(), file.getPath().getParent().toString(), file.getPath().getName(), file.getLen(), Timestamp.fromEpochMillis(file.getModificationTime()), Timestamp.fromEpochMillis(file.getAccessTime()), file.getOwner(), null, null, null, null, null, new GenericMap(Collections.emptyMap()));
    }

    public static GenericRow toRow(Object ... values) {
        GenericRow row = new GenericRow(values.length);
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            if (value instanceof String) {
                value = BinaryString.fromString((String)value);
            }
            row.setField(i, value);
        }
        return row;
    }
}

