/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.apache.datasketches.memory.internal;

import java.nio.ByteOrder;
import org.apache.paimon.shade.org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.BaseWritableBufferImpl;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.BaseWritableMemoryImpl;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.DirectNonNativeWritableBufferImpl;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.DirectNonNativeWritableMemoryImpl;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.DirectWritableMemoryImpl;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.NativeWritableBufferImpl;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.StepBoolean;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.Util;

final class DirectWritableBufferImpl
extends NativeWritableBufferImpl {
    private static final int id = 72;
    private final long nativeBaseOffset;
    private final StepBoolean valid;
    private final MemoryRequestServer memReqSvr;
    private final byte typeId;

    DirectWritableBufferImpl(long nativeBaseOffset, long regionOffset, long capacityBytes, int typeId, StepBoolean valid, MemoryRequestServer memReqSvr) {
        super(null, nativeBaseOffset, regionOffset, capacityBytes);
        this.nativeBaseOffset = nativeBaseOffset;
        this.valid = valid;
        this.memReqSvr = memReqSvr;
        this.typeId = (byte)(0x48 | typeId & 7);
    }

    @Override
    BaseWritableBufferImpl toWritableRegion(long offsetBytes, long capacityBytes, boolean readOnly, ByteOrder byteOrder) {
        int type = DirectWritableBufferImpl.setReadOnlyType(this.typeId, readOnly) | 2;
        return Util.isNativeByteOrder(byteOrder) ? new DirectWritableBufferImpl(this.nativeBaseOffset, this.getRegionOffset(offsetBytes), capacityBytes, type, this.valid, this.memReqSvr) : new DirectNonNativeWritableBufferImpl(this.nativeBaseOffset, this.getRegionOffset(offsetBytes), capacityBytes, type, this.valid, this.memReqSvr);
    }

    @Override
    BaseWritableBufferImpl toDuplicate(boolean readOnly, ByteOrder byteOrder) {
        int type = DirectWritableBufferImpl.setReadOnlyType(this.typeId, readOnly) | 4;
        return Util.isNativeByteOrder(byteOrder) ? new DirectWritableBufferImpl(this.nativeBaseOffset, this.getRegionOffset(), this.getCapacity(), type, this.valid, this.memReqSvr) : new DirectNonNativeWritableBufferImpl(this.nativeBaseOffset, this.getRegionOffset(), this.getCapacity(), type, this.valid, this.memReqSvr);
    }

    @Override
    BaseWritableMemoryImpl toWritableMemory(boolean readOnly, ByteOrder byteOrder) {
        byte type = DirectWritableBufferImpl.setReadOnlyType(this.typeId, readOnly);
        return Util.isNativeByteOrder(byteOrder) ? new DirectWritableMemoryImpl(this.nativeBaseOffset, this.getRegionOffset(), this.getCapacity(), type, this.valid, this.memReqSvr) : new DirectNonNativeWritableMemoryImpl(this.nativeBaseOffset, this.getRegionOffset(), this.getCapacity(), type, this.valid, this.memReqSvr);
    }

    @Override
    public MemoryRequestServer getMemoryRequestServer() {
        this.assertValid();
        return this.memReqSvr;
    }

    @Override
    long getNativeBaseOffset() {
        return this.nativeBaseOffset;
    }

    @Override
    int getTypeId() {
        return this.typeId & 0xFF;
    }

    @Override
    public boolean isValid() {
        return this.valid.get();
    }
}

