/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.rest;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.paimon.rest.ErrorHandler;
import org.apache.paimon.rest.HttpClientOptions;
import org.apache.paimon.rest.RESTClient;
import org.apache.paimon.rest.RESTRequest;
import org.apache.paimon.rest.RESTResponse;
import org.apache.paimon.rest.exceptions.RESTException;
import org.apache.paimon.rest.responses.ErrorResponse;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.paimon.shade.okhttp3.ConnectionSpec;
import org.apache.paimon.shade.okhttp3.Dispatcher;
import org.apache.paimon.shade.okhttp3.Headers;
import org.apache.paimon.shade.okhttp3.MediaType;
import org.apache.paimon.shade.okhttp3.OkHttpClient;
import org.apache.paimon.shade.okhttp3.Request;
import org.apache.paimon.shade.okhttp3.RequestBody;
import org.apache.paimon.shade.okhttp3.Response;
import org.apache.paimon.utils.ThreadPoolUtils;

public class HttpClient
implements RESTClient {
    private final OkHttpClient okHttpClient;
    private final String uri;
    private final ObjectMapper mapper;
    private final ErrorHandler errorHandler;
    private static final String THREAD_NAME = "REST-CATALOG-HTTP-CLIENT-THREAD-POOL";
    private static final MediaType MEDIA_TYPE = MediaType.parse("application/json");

    public HttpClient(HttpClientOptions httpClientOptions) {
        this.uri = httpClientOptions.uri();
        this.mapper = httpClientOptions.mapper();
        this.okHttpClient = HttpClient.createHttpClient(httpClientOptions);
        this.errorHandler = httpClientOptions.errorHandler();
    }

    @Override
    public <T extends RESTResponse> T get(String path, Class<T> responseType, Map<String, String> headers) {
        Request request = new Request.Builder().url(this.uri + path).get().headers(Headers.of(headers)).build();
        return this.exec(request, responseType);
    }

    @Override
    public <T extends RESTResponse> T post(String path, RESTRequest body, Class<T> responseType, Map<String, String> headers) {
        try {
            RequestBody requestBody = this.buildRequestBody(body);
            Request request = new Request.Builder().url(this.uri + path).post(requestBody).headers(Headers.of(headers)).build();
            return this.exec(request, responseType);
        }
        catch (JsonProcessingException e) {
            throw new RESTException(e, "build request failed.", new Object[0]);
        }
    }

    @Override
    public <T extends RESTResponse> T delete(String path, Map<String, String> headers) {
        Request request = new Request.Builder().url(this.uri + path).delete().headers(Headers.of(headers)).build();
        return this.exec(request, null);
    }

    @Override
    public void close() throws IOException {
        this.okHttpClient.dispatcher().cancelAll();
        this.okHttpClient.connectionPool().evictAll();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T extends RESTResponse> T exec(Request request, Class<T> responseType) {
        try (Response response = this.okHttpClient.newCall(request).execute();){
            RESTResponse rESTResponse;
            String responseBodyStr;
            String string = responseBodyStr = response.body() != null ? response.body().string() : null;
            if (!response.isSuccessful()) {
                ErrorResponse error = new ErrorResponse(responseBodyStr != null ? responseBodyStr : "response body is null", response.code());
                this.errorHandler.accept(error);
            }
            if (responseType != null && responseBodyStr != null) {
                rESTResponse = (RESTResponse)this.mapper.readValue(responseBodyStr, responseType);
                return (T)rESTResponse;
            }
            if (responseType == null) {
                rESTResponse = null;
                return (T)rESTResponse;
            }
            throw new RESTException("response body is null.", new Object[0]);
        }
        catch (RESTException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RESTException(e, "rest exception", new Object[0]);
        }
    }

    private RequestBody buildRequestBody(RESTRequest body) throws JsonProcessingException {
        return RequestBody.create(this.mapper.writeValueAsBytes(body), MEDIA_TYPE);
    }

    private static OkHttpClient createHttpClient(HttpClientOptions httpClientOptions) {
        SynchronousQueue<Runnable> workQueue = new SynchronousQueue<Runnable>();
        ThreadPoolExecutor executorService = ThreadPoolUtils.createCachedThreadPool(httpClientOptions.threadPoolSize(), THREAD_NAME, workQueue);
        OkHttpClient.Builder builder = new OkHttpClient.Builder().dispatcher(new Dispatcher(executorService)).retryOnConnectionFailure(true).connectionSpecs(Arrays.asList(ConnectionSpec.MODERN_TLS, ConnectionSpec.COMPATIBLE_TLS, ConnectionSpec.CLEARTEXT));
        httpClientOptions.connectTimeout().ifPresent(builder::connectTimeout);
        httpClientOptions.readTimeout().ifPresent(builder::readTimeout);
        return builder.build();
    }
}

