/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.partition.actions;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.paimon.fs.Path;
import org.apache.paimon.metastore.MetastoreClient;
import org.apache.paimon.partition.actions.PartitionMarkDoneAction;
import org.apache.paimon.shade.guava30.com.google.common.collect.Iterators;
import org.apache.paimon.utils.PartitionPathUtils;

public class AddDonePartitionAction
implements PartitionMarkDoneAction {
    private final MetastoreClient metastoreClient;

    public AddDonePartitionAction(MetastoreClient metastoreClient) {
        this.metastoreClient = metastoreClient;
    }

    @Override
    public void markDone(String partition) throws Exception {
        LinkedHashMap<String, String> doneSpec = PartitionPathUtils.extractPartitionSpecFromPath(new Path(partition));
        Map.Entry<String, String> lastField = this.tailEntry(doneSpec);
        doneSpec.put(lastField.getKey(), lastField.getValue() + ".done");
        this.metastoreClient.addPartition(doneSpec);
    }

    private Map.Entry<String, String> tailEntry(LinkedHashMap<String, String> partitionSpec) {
        return Iterators.getLast(partitionSpec.entrySet().iterator());
    }

    @Override
    public void close() throws IOException {
        try {
            this.metastoreClient.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

