/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.deletionvectors.ApplyDeletionVectorReader;
import org.apache.paimon.deletionvectors.DeletionVector;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.fileindex.FileIndexResult;
import org.apache.paimon.fileindex.bitmap.ApplyBitmapIndexRecordReader;
import org.apache.paimon.fileindex.bitmap.BitmapIndexResult;
import org.apache.paimon.format.FileFormatDiscover;
import org.apache.paimon.format.FormatKey;
import org.apache.paimon.format.FormatReaderContext;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataFilePathFactory;
import org.apache.paimon.io.DataFileRecordReader;
import org.apache.paimon.io.FileIndexEvaluator;
import org.apache.paimon.mergetree.compact.ConcatRecordReader;
import org.apache.paimon.operation.SplitRead;
import org.apache.paimon.partition.PartitionUtils;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.reader.EmptyFileRecordReader;
import org.apache.paimon.reader.FileRecordReader;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.FormatReaderMapping;
import org.apache.paimon.utils.IOExceptionSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawFileSplitRead
implements SplitRead<InternalRow> {
    private static final Logger LOG = LoggerFactory.getLogger(RawFileSplitRead.class);
    private final FileIO fileIO;
    private final SchemaManager schemaManager;
    private final TableSchema schema;
    private final FileFormatDiscover formatDiscover;
    private final FileStorePathFactory pathFactory;
    private final Map<FormatKey, FormatReaderMapping> formatReaderMappings;
    private final boolean fileIndexReadEnabled;
    private RowType readRowType;
    @Nullable
    private List<Predicate> filters;

    public RawFileSplitRead(FileIO fileIO, SchemaManager schemaManager, TableSchema schema, RowType rowType, FileFormatDiscover formatDiscover, FileStorePathFactory pathFactory, boolean fileIndexReadEnabled) {
        this.fileIO = fileIO;
        this.schemaManager = schemaManager;
        this.schema = schema;
        this.formatDiscover = formatDiscover;
        this.pathFactory = pathFactory;
        this.formatReaderMappings = new HashMap<FormatKey, FormatReaderMapping>();
        this.fileIndexReadEnabled = fileIndexReadEnabled;
        this.readRowType = rowType;
    }

    @Override
    public SplitRead<InternalRow> forceKeepDelete() {
        return this;
    }

    @Override
    public SplitRead<InternalRow> withIOManager(@Nullable IOManager ioManager) {
        return this;
    }

    @Override
    public SplitRead<InternalRow> withReadType(RowType readRowType) {
        this.readRowType = readRowType;
        return this;
    }

    public RawFileSplitRead withFilter(Predicate predicate) {
        if (predicate != null) {
            this.filters = PredicateBuilder.splitAnd(predicate);
        }
        return this;
    }

    @Override
    public RecordReader<InternalRow> createReader(DataSplit split) throws IOException {
        if (split.beforeFiles().size() > 0) {
            LOG.info("Ignore split before files: {}", split.beforeFiles());
        }
        List<DataFileMeta> files = split.dataFiles();
        DeletionVector.Factory dvFactory = DeletionVector.factory(this.fileIO, files, split.deletionFiles().orElse(null));
        ArrayList<IOExceptionSupplier<DeletionVector>> dvFactories = new ArrayList<IOExceptionSupplier<DeletionVector>>();
        for (DataFileMeta file : files) {
            dvFactories.add(() -> dvFactory.create(file.fileName()).orElse(null));
        }
        return this.createReader(split.partition(), split.bucket(), split.dataFiles(), dvFactories);
    }

    public RecordReader<InternalRow> createReader(BinaryRow partition, int bucket, List<DataFileMeta> files, @Nullable List<IOExceptionSupplier<DeletionVector>> dvFactories) throws IOException {
        DataFilePathFactory dataFilePathFactory = this.pathFactory.createDataFilePathFactory(partition, bucket);
        ArrayList suppliers = new ArrayList();
        List<DataField> readTableFields = this.readRowType.getFields();
        FormatReaderMapping.Builder formatReaderMappingBuilder = new FormatReaderMapping.Builder(this.formatDiscover, readTableFields, TableSchema::fields, this.filters);
        for (int i = 0; i < files.size(); ++i) {
            DataFileMeta file = files.get(i);
            String formatIdentifier = DataFilePathFactory.formatIdentifier(file.fileName());
            long schemaId = file.schemaId();
            Supplier<FormatReaderMapping> formatSupplier = () -> formatReaderMappingBuilder.build(formatIdentifier, this.schema, schemaId == this.schema.id() ? this.schema : this.schemaManager.schema(schemaId));
            FormatReaderMapping formatReaderMapping = this.formatReaderMappings.computeIfAbsent(new FormatKey(file.schemaId(), formatIdentifier), key -> (FormatReaderMapping)formatSupplier.get());
            IOExceptionSupplier<DeletionVector> dvFactory = dvFactories == null ? null : dvFactories.get(i);
            suppliers.add(() -> this.createFileReader(partition, file, dataFilePathFactory, formatReaderMapping, dvFactory));
        }
        return ConcatRecordReader.create(suppliers);
    }

    private FileRecordReader<InternalRow> createFileReader(BinaryRow partition, DataFileMeta file, DataFilePathFactory dataFilePathFactory, FormatReaderMapping formatReaderMapping, IOExceptionSupplier<DeletionVector> dvFactory) throws IOException {
        DeletionVector deletionVector;
        FileIndexResult fileIndexResult = null;
        if (this.fileIndexReadEnabled && !(fileIndexResult = FileIndexEvaluator.evaluate(this.fileIO, formatReaderMapping.getDataSchema(), formatReaderMapping.getDataFilters(), dataFilePathFactory, file)).remain()) {
            return new EmptyFileRecordReader<InternalRow>();
        }
        FormatReaderContext formatReaderContext = new FormatReaderContext(this.fileIO, dataFilePathFactory.toPath(file), file.fileSize(), fileIndexResult);
        FileRecordReader<InternalRow> fileRecordReader = new DataFileRecordReader(formatReaderMapping.getReaderFactory(), formatReaderContext, formatReaderMapping.getIndexMapping(), formatReaderMapping.getCastMapping(), PartitionUtils.create(formatReaderMapping.getPartitionPair(), partition));
        if (fileIndexResult instanceof BitmapIndexResult) {
            fileRecordReader = new ApplyBitmapIndexRecordReader(fileRecordReader, (BitmapIndexResult)fileIndexResult);
        }
        DeletionVector deletionVector2 = deletionVector = dvFactory == null ? null : dvFactory.get();
        if (deletionVector != null && !deletionVector.isEmpty()) {
            return new ApplyDeletionVectorReader(fileRecordReader, deletionVector);
        }
        return fileRecordReader;
    }
}

