/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.memory;

import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.memory.MemorySliceInput;
import org.apache.paimon.utils.MurmurHashUtils;

public final class MemorySlice
implements Comparable<MemorySlice> {
    private final MemorySegment segment;
    private final int offset;
    private final int length;

    public MemorySlice(MemorySegment segment, int offset, int length) {
        this.segment = segment;
        this.offset = offset;
        this.length = length;
    }

    public MemorySegment segment() {
        return this.segment;
    }

    public int offset() {
        return this.offset;
    }

    public int length() {
        return this.length;
    }

    public MemorySlice slice(int index, int length) {
        if (index == 0 && length == this.length) {
            return this;
        }
        return new MemorySlice(this.segment, this.offset + index, length);
    }

    public byte readByte(int position) {
        return this.segment.get(this.offset + position);
    }

    public int readInt(int position) {
        return this.segment.getInt(this.offset + position);
    }

    public long readLong(int position) {
        return this.segment.getLong(this.offset + position);
    }

    public byte[] getHeapMemory() {
        return this.segment.getHeapMemory();
    }

    public byte[] copyBytes() {
        byte[] bytes = new byte[this.length];
        this.segment.get(this.offset, bytes, 0, this.length);
        return bytes;
    }

    public MemorySliceInput toInput() {
        return new MemorySliceInput(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemorySlice slice = (MemorySlice)o;
        if (this.length != slice.length) {
            return false;
        }
        if (this.offset == slice.offset && this.segment == slice.segment) {
            return true;
        }
        return this.segment.equalTo(slice.segment, this.offset, slice.offset, this.length);
    }

    public int hashCode() {
        return MurmurHashUtils.hashBytes(this.segment, this.offset, this.length);
    }

    public static MemorySlice wrap(byte[] bytes) {
        return new MemorySlice(MemorySegment.wrap(bytes), 0, bytes.length);
    }

    public static MemorySlice wrap(MemorySegment segment) {
        return new MemorySlice(segment, 0, segment.size());
    }

    @Override
    public int compareTo(MemorySlice other) {
        int len = Math.min(this.length, other.length);
        for (int i = 0; i < len; ++i) {
            int res = (this.segment.get(this.offset + i) & 0xFF) - (other.segment.get(other.offset + i) & 0xFF);
            if (res == 0) continue;
            return res;
        }
        return this.length - other.length;
    }
}

