/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.lookup.sort;

import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import javax.annotation.Nullable;
import org.apache.paimon.compression.BlockCompressionFactory;
import org.apache.paimon.compression.BlockDecompressor;
import org.apache.paimon.io.PageFileInput;
import org.apache.paimon.io.cache.CacheManager;
import org.apache.paimon.lookup.LookupStoreReader;
import org.apache.paimon.lookup.sort.BlockCache;
import org.apache.paimon.lookup.sort.BlockHandle;
import org.apache.paimon.lookup.sort.BlockIterator;
import org.apache.paimon.lookup.sort.BlockReader;
import org.apache.paimon.lookup.sort.BlockTrailer;
import org.apache.paimon.lookup.sort.BloomFilterHandle;
import org.apache.paimon.lookup.sort.Footer;
import org.apache.paimon.lookup.sort.SortContext;
import org.apache.paimon.lookup.sort.SortLookupStoreUtils;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.memory.MemorySlice;
import org.apache.paimon.memory.MemorySliceInput;
import org.apache.paimon.utils.FileBasedBloomFilter;
import org.apache.paimon.utils.MurmurHashUtils;
import org.apache.paimon.utils.Preconditions;

public class SortLookupStoreReader
implements LookupStoreReader {
    private final Comparator<MemorySlice> comparator;
    private final String filePath;
    private final long fileSize;
    private final BlockIterator indexBlockIterator;
    @Nullable
    private FileBasedBloomFilter bloomFilter;
    private final BlockCache blockCache;
    private final PageFileInput fileInput;

    public SortLookupStoreReader(Comparator<MemorySlice> comparator, File file, int blockSize, SortContext context, CacheManager cacheManager) throws IOException {
        this.comparator = comparator;
        this.filePath = file.getAbsolutePath();
        this.fileSize = context.fileSize();
        this.fileInput = PageFileInput.create(file, blockSize, null, this.fileSize, null);
        this.blockCache = new BlockCache(this.fileInput.file(), cacheManager);
        Footer footer = this.readFooter();
        this.indexBlockIterator = this.readBlock(footer.getIndexBlockHandle(), true).iterator();
        BloomFilterHandle handle = footer.getBloomFilterHandle();
        if (handle != null) {
            this.bloomFilter = new FileBasedBloomFilter(this.fileInput, cacheManager, handle.expectedEntries(), handle.offset(), handle.size());
        }
    }

    private Footer readFooter() throws IOException {
        MemorySegment footerData = this.blockCache.getBlock(this.fileSize - 36L, 36, b -> b, true);
        return Footer.readFooter(MemorySlice.wrap(footerData).toInput());
    }

    @Override
    @Nullable
    public byte[] lookup(byte[] key) throws IOException {
        BlockIterator current;
        if (this.bloomFilter != null && !this.bloomFilter.testHash(MurmurHashUtils.hashBytes(key))) {
            return null;
        }
        MemorySlice keySlice = MemorySlice.wrap(key);
        this.indexBlockIterator.seekTo(keySlice);
        if (this.indexBlockIterator.hasNext() && (current = this.getNextBlock()).seekTo(keySlice)) {
            return current.next().getValue().copyBytes();
        }
        return null;
    }

    private BlockIterator getNextBlock() {
        MemorySlice blockHandle = this.indexBlockIterator.next().getValue();
        BlockReader dataBlock = this.readBlock(BlockHandle.readBlockHandle(blockHandle.toInput()), false);
        return dataBlock.iterator();
    }

    private BlockReader readBlock(BlockHandle blockHandle, boolean index) {
        MemorySegment trailerData = this.blockCache.getBlock(blockHandle.offset() + (long)blockHandle.size(), 5, b -> b, true);
        BlockTrailer blockTrailer = BlockTrailer.readBlockTrailer(MemorySlice.wrap(trailerData).toInput());
        MemorySegment unCompressedBlock = this.blockCache.getBlock(blockHandle.offset(), blockHandle.size(), bytes -> this.decompressBlock((byte[])bytes, blockTrailer), index);
        return new BlockReader(MemorySlice.wrap(unCompressedBlock), this.comparator);
    }

    private byte[] decompressBlock(byte[] compressedBytes, BlockTrailer blockTrailer) {
        MemorySegment compressed = MemorySegment.wrap(compressedBytes);
        int crc32cCode = SortLookupStoreUtils.crc32c(compressed, blockTrailer.getCompressionType());
        Preconditions.checkArgument(blockTrailer.getCrc32c() == crc32cCode, String.format("Expected CRC32C(%d) but found CRC32C(%d) for file(%s)", blockTrailer.getCrc32c(), crc32cCode, this.filePath));
        BlockCompressionFactory compressionFactory = BlockCompressionFactory.create(blockTrailer.getCompressionType());
        if (compressionFactory == null) {
            return compressedBytes;
        }
        MemorySliceInput compressedInput = MemorySlice.wrap(compressed).toInput();
        byte[] uncompressed = new byte[compressedInput.readVarLenInt()];
        BlockDecompressor decompressor = compressionFactory.getDecompressor();
        int uncompressedLength = decompressor.decompress(compressed.getHeapMemory(), compressedInput.position(), compressedInput.available(), uncompressed, 0);
        Preconditions.checkArgument(uncompressedLength == uncompressed.length);
        return uncompressed;
    }

    @Override
    public void close() throws IOException {
        if (this.bloomFilter != null) {
            this.bloomFilter.close();
        }
        this.blockCache.close();
        this.fileInput.close();
    }
}

