/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.lookup.sort;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.paimon.lookup.sort.BlockEntry;
import org.apache.paimon.memory.MemorySlice;
import org.apache.paimon.memory.MemorySliceInput;

public abstract class BlockIterator
implements Iterator<Map.Entry<MemorySlice, MemorySlice>> {
    protected final MemorySliceInput data;
    private final int recordCount;
    private final Comparator<MemorySlice> comparator;
    private BlockEntry polled;

    public BlockIterator(MemorySliceInput data, int recordCount, Comparator<MemorySlice> comparator) {
        this.data = data;
        this.recordCount = recordCount;
        this.comparator = comparator;
    }

    @Override
    public boolean hasNext() {
        return this.polled != null || this.data.isReadable();
    }

    @Override
    public BlockEntry next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.polled != null) {
            BlockEntry result = this.polled;
            this.polled = null;
            return result;
        }
        return this.readEntry();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean seekTo(MemorySlice targetKey) {
        int left = 0;
        int right = this.recordCount - 1;
        while (left <= right) {
            int mid = left + (right - left) / 2;
            this.seekTo(mid);
            BlockEntry midEntry = this.readEntry();
            int compare = this.comparator.compare(midEntry.getKey(), targetKey);
            if (compare == 0) {
                this.polled = midEntry;
                return true;
            }
            if (compare > 0) {
                this.polled = midEntry;
                right = mid - 1;
                continue;
            }
            left = mid + 1;
        }
        return false;
    }

    public abstract void seekTo(int var1);

    private BlockEntry readEntry() {
        Objects.requireNonNull(this.data, "data is null");
        int keyLength = this.data.readVarLenInt();
        MemorySlice key = this.data.readSlice(keyLength);
        int valueLength = this.data.readVarLenInt();
        MemorySlice value = this.data.readSlice(valueLength);
        return new BlockEntry(key, value);
    }
}

