/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet.reader;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.paimon.data.columnar.writable.WritableFloatVector;
import org.apache.paimon.data.columnar.writable.WritableIntVector;
import org.apache.paimon.format.parquet.reader.AbstractColumnReader;
import org.apache.paimon.shade.org.apache.parquet.column.ColumnDescriptor;
import org.apache.paimon.shade.org.apache.parquet.column.page.PageReadStore;
import org.apache.paimon.shade.org.apache.parquet.schema.PrimitiveType;

public class FloatColumnReader
extends AbstractColumnReader<WritableFloatVector> {
    public FloatColumnReader(ColumnDescriptor descriptor, PageReadStore pageReadStore) throws IOException {
        super(descriptor, pageReadStore);
        this.checkTypeName(PrimitiveType.PrimitiveTypeName.FLOAT);
    }

    @Override
    protected void readBatch(int rowId, int num, WritableFloatVector column) {
        int left = num;
        while (left > 0) {
            if (this.runLenDecoder.currentCount == 0) {
                this.runLenDecoder.readNextGroup();
            }
            int n = Math.min(left, this.runLenDecoder.currentCount);
            switch (this.runLenDecoder.mode) {
                case RLE: {
                    if (this.runLenDecoder.currentValue == this.maxDefLevel) {
                        this.readFloats(n, column, rowId);
                        break;
                    }
                    column.setNulls(rowId, n);
                    break;
                }
                case PACKED: {
                    for (int i = 0; i < n; ++i) {
                        if (this.runLenDecoder.currentBuffer[this.runLenDecoder.currentBufferIdx++] == this.maxDefLevel) {
                            column.setFloat(rowId + i, this.readFloat());
                            continue;
                        }
                        column.setNullAt(rowId + i);
                    }
                    break;
                }
            }
            rowId += n;
            left -= n;
            this.runLenDecoder.currentCount -= n;
        }
    }

    @Override
    protected void skipBatch(int num) {
        int left = num;
        while (left > 0) {
            if (this.runLenDecoder.currentCount == 0) {
                this.runLenDecoder.readNextGroup();
            }
            int n = Math.min(left, this.runLenDecoder.currentCount);
            switch (this.runLenDecoder.mode) {
                case RLE: {
                    if (this.runLenDecoder.currentValue != this.maxDefLevel) break;
                    this.skipFloat(n);
                    break;
                }
                case PACKED: {
                    for (int i = 0; i < n; ++i) {
                        if (this.runLenDecoder.currentBuffer[this.runLenDecoder.currentBufferIdx++] != this.maxDefLevel) continue;
                        this.skipFloat(1);
                    }
                    break;
                }
            }
            left -= n;
            this.runLenDecoder.currentCount -= n;
        }
    }

    private void skipFloat(int num) {
        this.skipDataBuffer(4 * num);
    }

    @Override
    protected void readBatchFromDictionaryIds(int rowId, int num, WritableFloatVector column, WritableIntVector dictionaryIds) {
        for (int i = rowId; i < rowId + num; ++i) {
            if (column.isNullAt(i)) continue;
            column.setFloat(i, this.dictionary.decodeToFloat(dictionaryIds.getInt(i)));
        }
    }

    private float readFloat() {
        return this.readDataBuffer(4).getFloat();
    }

    private void readFloats(int total, WritableFloatVector c, int rowId) {
        int requiredBytes = total * 4;
        ByteBuffer buffer = this.readDataBuffer(requiredBytes);
        if (buffer.hasArray()) {
            int offset = buffer.arrayOffset() + buffer.position();
            c.setFloatsFromBinary(rowId, total, buffer.array(), offset);
        } else {
            for (int i = 0; i < total; ++i) {
                c.setFloat(rowId + i, buffer.getFloat());
            }
        }
    }
}

