/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet.reader;

import java.io.IOException;
import org.apache.paimon.data.columnar.writable.WritableBytesVector;
import org.apache.paimon.data.columnar.writable.WritableColumnVector;
import org.apache.paimon.data.columnar.writable.WritableIntVector;
import org.apache.paimon.format.parquet.reader.FixedLenBytesColumnReader;
import org.apache.paimon.shade.org.apache.parquet.column.ColumnDescriptor;
import org.apache.paimon.shade.org.apache.parquet.column.page.PageReadStore;

public class FixedLenBytesBinaryColumnReader<VECTOR extends WritableColumnVector>
extends FixedLenBytesColumnReader<VECTOR> {
    public FixedLenBytesBinaryColumnReader(ColumnDescriptor descriptor, PageReadStore pageReadStore, int precision) throws IOException {
        super(descriptor, pageReadStore, precision);
    }

    @Override
    protected void readBatch(int rowId, int num, VECTOR column) {
        int bytesLen = this.descriptor.getPrimitiveType().getTypeLength();
        WritableBytesVector bytesVector = (WritableBytesVector)column;
        for (int i = 0; i < num; ++i) {
            if (this.runLenDecoder.readInteger() == this.maxDefLevel) {
                byte[] bytes = this.readDataBinary(bytesLen).getBytesUnsafe();
                bytesVector.putByteArray(rowId + i, bytes, 0, bytes.length);
                continue;
            }
            bytesVector.setNullAt(rowId + i);
        }
    }

    @Override
    protected void skipBatch(int num) {
        int bytesLen = this.descriptor.getPrimitiveType().getTypeLength();
        for (int i = 0; i < num; ++i) {
            if (this.runLenDecoder.readInteger() != this.maxDefLevel) continue;
            this.skipDataBinary(bytesLen);
        }
    }

    @Override
    protected void readBatchFromDictionaryIds(int rowId, int num, VECTOR column, WritableIntVector dictionaryIds) {
        WritableBytesVector bytesVector = (WritableBytesVector)column;
        for (int i = rowId; i < rowId + num; ++i) {
            if (bytesVector.isNullAt(i)) continue;
            byte[] v = this.dictionary.decodeToBinary(dictionaryIds.getInt(i)).getBytesUnsafe();
            bytesVector.putByteArray(i, v, 0, v.length);
        }
    }
}

