/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet.reader;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.paimon.data.columnar.writable.WritableByteVector;
import org.apache.paimon.data.columnar.writable.WritableIntVector;
import org.apache.paimon.format.parquet.reader.AbstractColumnReader;
import org.apache.paimon.shade.org.apache.parquet.column.ColumnDescriptor;
import org.apache.paimon.shade.org.apache.parquet.column.page.PageReadStore;
import org.apache.paimon.shade.org.apache.parquet.schema.PrimitiveType;

public class ByteColumnReader
extends AbstractColumnReader<WritableByteVector> {
    public ByteColumnReader(ColumnDescriptor descriptor, PageReadStore pageReadStore) throws IOException {
        super(descriptor, pageReadStore);
        this.checkTypeName(PrimitiveType.PrimitiveTypeName.INT32);
    }

    @Override
    protected void readBatch(int rowId, int num, WritableByteVector column) {
        int left = num;
        while (left > 0) {
            if (this.runLenDecoder.currentCount == 0) {
                this.runLenDecoder.readNextGroup();
            }
            int n = Math.min(left, this.runLenDecoder.currentCount);
            switch (this.runLenDecoder.mode) {
                case RLE: {
                    if (this.runLenDecoder.currentValue == this.maxDefLevel) {
                        this.readBytes(n, column, rowId);
                        break;
                    }
                    column.setNulls(rowId, n);
                    break;
                }
                case PACKED: {
                    for (int i = 0; i < n; ++i) {
                        if (this.runLenDecoder.currentBuffer[this.runLenDecoder.currentBufferIdx++] == this.maxDefLevel) {
                            column.setByte(rowId + i, this.readByte());
                            continue;
                        }
                        column.setNullAt(rowId + i);
                    }
                    break;
                }
            }
            rowId += n;
            left -= n;
            this.runLenDecoder.currentCount -= n;
        }
    }

    @Override
    protected void skipBatch(int num) {
        int left = num;
        while (left > 0) {
            if (this.runLenDecoder.currentCount == 0) {
                this.runLenDecoder.readNextGroup();
            }
            int n = Math.min(left, this.runLenDecoder.currentCount);
            switch (this.runLenDecoder.mode) {
                case RLE: {
                    if (this.runLenDecoder.currentValue != this.maxDefLevel) break;
                    this.skipByte(n);
                    break;
                }
                case PACKED: {
                    for (int i = 0; i < n; ++i) {
                        if (this.runLenDecoder.currentBuffer[this.runLenDecoder.currentBufferIdx++] != this.maxDefLevel) continue;
                        this.skipByte(1);
                    }
                    break;
                }
            }
            left -= n;
            this.runLenDecoder.currentCount -= n;
        }
    }

    private void skipByte(int num) {
        this.skipDataBuffer(4 * num);
    }

    @Override
    protected void readBatchFromDictionaryIds(int rowId, int num, WritableByteVector column, WritableIntVector dictionaryIds) {
        for (int i = rowId; i < rowId + num; ++i) {
            if (column.isNullAt(i)) continue;
            column.setByte(i, (byte)this.dictionary.decodeToInt(dictionaryIds.getInt(i)));
        }
    }

    private byte readByte() {
        return (byte)this.readDataBuffer(4).getInt();
    }

    private void readBytes(int total, WritableByteVector c, int rowId) {
        int requiredBytes = total * 4;
        ByteBuffer buffer = this.readDataBuffer(requiredBytes);
        for (int i = 0; i < total; ++i) {
            c.setByte(rowId + i, buffer.get());
            buffer.position(buffer.position() + 3);
        }
    }
}

