/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.utils;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.stats.CatalogColumnStatistics;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataBase;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataBinary;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataBoolean;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataDate;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataDouble;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataLong;
import org.apache.flink.table.catalog.stats.CatalogColumnStatisticsDataString;
import org.apache.flink.table.catalog.stats.CatalogTableStatistics;
import org.apache.paimon.Snapshot;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.stats.ColStats;
import org.apache.paimon.stats.Statistics;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataTypeRoot;

public class TableStatsUtil {
    @Nullable
    public static Statistics createTableStats(FileStoreTable table, CatalogTableStatistics catalogTableStatistics) {
        Snapshot snapshot = table.snapshotManager().latestSnapshot();
        if (snapshot == null) {
            return null;
        }
        return new Statistics(snapshot.id(), snapshot.schemaId(), catalogTableStatistics.getRowCount(), catalogTableStatistics.getTotalSize());
    }

    @Nullable
    public static Statistics createTableColumnStats(FileStoreTable table, CatalogColumnStatistics columnStatistics) {
        if (!table.statistics().isPresent()) {
            return null;
        }
        Statistics statistics = table.statistics().get();
        List<DataField> fields = table.schema().fields();
        HashMap tableColumnStatsMap = new HashMap(fields.size());
        for (DataField field : fields) {
            CatalogColumnStatisticsDataBase catalogColumnStatisticsDataBase = (CatalogColumnStatisticsDataBase)columnStatistics.getColumnStatisticsData().get(field.name());
            if (catalogColumnStatisticsDataBase == null) continue;
            tableColumnStatsMap.put(field.name(), TableStatsUtil.getPaimonColStats(field, catalogColumnStatisticsDataBase));
        }
        statistics.colStats().putAll(tableColumnStatsMap);
        return statistics;
    }

    private static ColStats<?> getPaimonColStats(DataField field, CatalogColumnStatisticsDataBase colStat) {
        DataTypeRoot typeRoot = field.type().getTypeRoot();
        if (colStat instanceof CatalogColumnStatisticsDataString) {
            CatalogColumnStatisticsDataString stringColStat = (CatalogColumnStatisticsDataString)colStat;
            if (typeRoot.equals((Object)DataTypeRoot.CHAR) || typeRoot.equals((Object)DataTypeRoot.VARCHAR)) {
                return ColStats.newColStats(field.id(), null != stringColStat.getNdv() ? stringColStat.getNdv() : null, null, null, null != stringColStat.getNullCount() ? stringColStat.getNullCount() : null, null != stringColStat.getAvgLength() ? Long.valueOf(stringColStat.getAvgLength().longValue()) : null, null != stringColStat.getMaxLength() ? stringColStat.getMaxLength() : null);
            }
        } else if (colStat instanceof CatalogColumnStatisticsDataBoolean) {
            CatalogColumnStatisticsDataBoolean booleanColStat = (CatalogColumnStatisticsDataBoolean)colStat;
            if (typeRoot.equals((Object)DataTypeRoot.BOOLEAN)) {
                return ColStats.newColStats(field.id(), (booleanColStat.getFalseCount() > 0L ? 1L : 0L) + (booleanColStat.getTrueCount() > 0L ? 1L : 0L), null, null, booleanColStat.getNullCount(), null, null);
            }
        } else if (colStat instanceof CatalogColumnStatisticsDataLong) {
            CatalogColumnStatisticsDataLong longColStat = (CatalogColumnStatisticsDataLong)colStat;
            if (typeRoot.equals((Object)DataTypeRoot.INTEGER)) {
                return ColStats.newColStats(field.id(), null != longColStat.getNdv() ? longColStat.getNdv() : null, null != longColStat.getMin() ? Integer.valueOf(longColStat.getMin().intValue()) : null, null != longColStat.getMax() ? Integer.valueOf(longColStat.getMax().intValue()) : null, null != longColStat.getNullCount() ? longColStat.getNullCount() : null, null, null);
            }
            if (typeRoot.equals((Object)DataTypeRoot.TINYINT)) {
                return ColStats.newColStats(field.id(), null != longColStat.getNdv() ? longColStat.getNdv() : null, null != longColStat.getMin() ? Byte.valueOf(longColStat.getMin().byteValue()) : null, null != longColStat.getMax() ? Byte.valueOf(longColStat.getMax().byteValue()) : null, null != longColStat.getNullCount() ? longColStat.getNullCount() : null, null, null);
            }
            if (typeRoot.equals((Object)DataTypeRoot.SMALLINT)) {
                return ColStats.newColStats(field.id(), null != longColStat.getNdv() ? longColStat.getNdv() : null, null != longColStat.getMin() ? Short.valueOf(longColStat.getMin().shortValue()) : null, null != longColStat.getMax() ? Short.valueOf(longColStat.getMax().shortValue()) : null, null != longColStat.getNullCount() ? longColStat.getNullCount() : null, null, null);
            }
            if (typeRoot.equals((Object)DataTypeRoot.BIGINT)) {
                return ColStats.newColStats(field.id(), null != longColStat.getNdv() ? longColStat.getNdv() : null, null != longColStat.getMin() ? longColStat.getMin() : null, null != longColStat.getMax() ? longColStat.getMax() : null, null != longColStat.getNullCount() ? longColStat.getNullCount() : null, null, null);
            }
            if (typeRoot.equals((Object)DataTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE)) {
                return ColStats.newColStats(field.id(), null != longColStat.getNdv() ? longColStat.getNdv() : null, null != longColStat.getMin() ? org.apache.paimon.data.Timestamp.fromSQLTimestamp(new Timestamp(longColStat.getMin())) : null, null != longColStat.getMax() ? org.apache.paimon.data.Timestamp.fromSQLTimestamp(new Timestamp(longColStat.getMax())) : null, null != longColStat.getNullCount() ? longColStat.getNullCount() : null, null, null);
            }
        } else if (colStat instanceof CatalogColumnStatisticsDataDouble) {
            CatalogColumnStatisticsDataDouble doubleColumnStatsData = (CatalogColumnStatisticsDataDouble)colStat;
            if (typeRoot.equals((Object)DataTypeRoot.FLOAT)) {
                return ColStats.newColStats(field.id(), null != doubleColumnStatsData.getNdv() ? doubleColumnStatsData.getNdv() : null, null != doubleColumnStatsData.getMin() ? Float.valueOf(doubleColumnStatsData.getMin().floatValue()) : null, null != doubleColumnStatsData.getMax() ? Float.valueOf(doubleColumnStatsData.getMax().floatValue()) : null, null != doubleColumnStatsData.getNullCount() ? doubleColumnStatsData.getNullCount() : null, null, null);
            }
            if (typeRoot.equals((Object)DataTypeRoot.DOUBLE)) {
                return ColStats.newColStats(field.id(), null != doubleColumnStatsData.getNdv() ? doubleColumnStatsData.getNdv() : null, null != doubleColumnStatsData.getMin() ? doubleColumnStatsData.getMin() : null, null != doubleColumnStatsData.getMax() ? doubleColumnStatsData.getMax() : null, null != doubleColumnStatsData.getNullCount() ? doubleColumnStatsData.getNullCount() : null, null, null);
            }
            if (typeRoot.equals((Object)DataTypeRoot.DECIMAL)) {
                BigDecimal max = BigDecimal.valueOf(doubleColumnStatsData.getMax());
                BigDecimal min = BigDecimal.valueOf(doubleColumnStatsData.getMin());
                return ColStats.newColStats(field.id(), null != doubleColumnStatsData.getNdv() ? doubleColumnStatsData.getNdv() : null, null != doubleColumnStatsData.getMin() ? Decimal.fromBigDecimal(min, min.precision(), min.scale()) : null, null != doubleColumnStatsData.getMax() ? Decimal.fromBigDecimal(max, max.precision(), max.scale()) : null, null != doubleColumnStatsData.getNullCount() ? doubleColumnStatsData.getNullCount() : null, null, null);
            }
        } else if (colStat instanceof CatalogColumnStatisticsDataDate) {
            CatalogColumnStatisticsDataDate dateColumnStatsData = (CatalogColumnStatisticsDataDate)colStat;
            if (typeRoot.equals((Object)DataTypeRoot.DATE)) {
                return ColStats.newColStats(field.id(), null != dateColumnStatsData.getNdv() ? dateColumnStatsData.getNdv() : null, null != dateColumnStatsData.getMin() ? Integer.valueOf(new Long(dateColumnStatsData.getMin().getDaysSinceEpoch()).intValue()) : null, null != dateColumnStatsData.getMax() ? Integer.valueOf(new Long(dateColumnStatsData.getMax().getDaysSinceEpoch()).intValue()) : null, null != dateColumnStatsData.getNullCount() ? dateColumnStatsData.getNullCount() : null, null, null);
            }
        } else if (colStat instanceof CatalogColumnStatisticsDataBinary) {
            CatalogColumnStatisticsDataBinary binaryColumnStatsData = (CatalogColumnStatisticsDataBinary)colStat;
            if (typeRoot.equals((Object)DataTypeRoot.VARBINARY) || typeRoot.equals((Object)DataTypeRoot.BINARY)) {
                return ColStats.newColStats(field.id(), null, null, null, null != binaryColumnStatsData.getNullCount() ? binaryColumnStatsData.getNullCount() : null, null != binaryColumnStatsData.getAvgLength() ? Long.valueOf(binaryColumnStatsData.getAvgLength().longValue()) : null, null != binaryColumnStatsData.getMaxLength() ? binaryColumnStatsData.getMaxLength() : null);
            }
        }
        throw new CatalogException(String.format("Flink does not support convert ColumnStats '%s' for Paimon column type '%s' yet", colStat, field.type()));
    }
}

