/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.source.operator;

import java.util.regex.Pattern;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.source.ReaderOutput;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.connector.source.SourceReader;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.core.io.InputStatus;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.paimon.append.MultiTableUnawareAppendCompactionTask;
import org.apache.paimon.catalog.CatalogLoader;
import org.apache.paimon.flink.compact.MultiTableScanBase;
import org.apache.paimon.flink.compact.MultiUnawareBucketTableScan;
import org.apache.paimon.flink.sink.MultiTableCompactionTaskTypeInfo;
import org.apache.paimon.flink.source.AbstractNonCoordinatedSourceReader;
import org.apache.paimon.flink.source.SimpleSourceSplit;
import org.apache.paimon.flink.source.operator.CombinedCompactorSource;

public class CombinedUnawareStreamingSource
extends CombinedCompactorSource<MultiTableUnawareAppendCompactionTask> {
    private final long monitorInterval;

    public CombinedUnawareStreamingSource(CatalogLoader catalogLoader, Pattern includingPattern, Pattern excludingPattern, Pattern databasePattern, long monitorInterval) {
        super(catalogLoader, includingPattern, excludingPattern, databasePattern, true);
        this.monitorInterval = monitorInterval;
    }

    public SourceReader<MultiTableUnawareAppendCompactionTask, SimpleSourceSplit> createReader(SourceReaderContext sourceReaderContext) throws Exception {
        return new Reader();
    }

    public static DataStream<MultiTableUnawareAppendCompactionTask> buildSource(StreamExecutionEnvironment env, String name, CatalogLoader catalogLoader, Pattern includingPattern, Pattern excludingPattern, Pattern databasePattern, long monitorInterval) {
        CombinedUnawareStreamingSource source = new CombinedUnawareStreamingSource(catalogLoader, includingPattern, excludingPattern, databasePattern, monitorInterval);
        MultiTableCompactionTaskTypeInfo compactionTaskTypeInfo = new MultiTableCompactionTaskTypeInfo();
        return env.fromSource((Source)source, WatermarkStrategy.noWatermarks(), name, (TypeInformation)compactionTaskTypeInfo).forceNonParallel();
    }

    private class Reader
    extends AbstractNonCoordinatedSourceReader<MultiTableUnawareAppendCompactionTask> {
        private MultiTableScanBase<MultiTableUnawareAppendCompactionTask> tableScan;

        private Reader() {
        }

        @Override
        public void start() {
            super.start();
            this.tableScan = new MultiUnawareBucketTableScan(CombinedUnawareStreamingSource.this.catalogLoader, CombinedUnawareStreamingSource.this.includingPattern, CombinedUnawareStreamingSource.this.excludingPattern, CombinedUnawareStreamingSource.this.databasePattern, CombinedUnawareStreamingSource.this.isStreaming);
        }

        public InputStatus pollNext(ReaderOutput<MultiTableUnawareAppendCompactionTask> readerOutput) throws Exception {
            MultiTableScanBase.ScanResult scanResult = this.tableScan.scanTable(readerOutput);
            if (scanResult == MultiTableScanBase.ScanResult.FINISHED) {
                return InputStatus.END_OF_INPUT;
            }
            if (scanResult == MultiTableScanBase.ScanResult.IS_EMPTY) {
                Thread.sleep(CombinedUnawareStreamingSource.this.monitorInterval);
            }
            return InputStatus.MORE_AVAILABLE;
        }

        @Override
        public void close() throws Exception {
            super.close();
            if (this.tableScan != null) {
                this.tableScan.close();
            }
        }
    }
}

