/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.source.operator;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.source.ReaderOutput;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.connector.source.SourceReader;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.core.io.InputStatus;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.paimon.append.MultiTableUnawareAppendCompactionTask;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.CatalogLoader;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.flink.compact.MultiTableScanBase;
import org.apache.paimon.flink.compact.MultiUnawareBucketTableScan;
import org.apache.paimon.flink.sink.MultiTableCompactionTaskTypeInfo;
import org.apache.paimon.flink.source.AbstractNonCoordinatedSourceReader;
import org.apache.paimon.flink.source.SimpleSourceSplit;
import org.apache.paimon.flink.source.operator.CombinedCompactorSource;
import org.apache.paimon.flink.source.operator.MultiUnawareTablesReadOperator;
import org.apache.paimon.manifest.PartitionEntry;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombinedUnawareBatchSource
extends CombinedCompactorSource<MultiTableUnawareAppendCompactionTask> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CombinedUnawareBatchSource.class);

    public CombinedUnawareBatchSource(CatalogLoader catalogLoader, Pattern includingPattern, Pattern excludingPattern, Pattern databasePattern) {
        super(catalogLoader, includingPattern, excludingPattern, databasePattern, false);
    }

    public SourceReader<MultiTableUnawareAppendCompactionTask, SimpleSourceSplit> createReader(SourceReaderContext sourceReaderContext) throws Exception {
        return new Reader();
    }

    public static DataStream<MultiTableUnawareAppendCompactionTask> buildSource(StreamExecutionEnvironment env, String name, CatalogLoader catalogLoader, Pattern includingPattern, Pattern excludingPattern, Pattern databasePattern, @Nullable Duration partitionIdleTime) {
        CombinedUnawareBatchSource combinedUnawareBatchSource = new CombinedUnawareBatchSource(catalogLoader, includingPattern, excludingPattern, databasePattern);
        MultiTableCompactionTaskTypeInfo compactionTaskTypeInfo = new MultiTableCompactionTaskTypeInfo();
        SingleOutputStreamOperator source = env.fromSource((Source)combinedUnawareBatchSource, WatermarkStrategy.noWatermarks(), name, (TypeInformation)compactionTaskTypeInfo).forceNonParallel();
        if (partitionIdleTime != null) {
            source = source.transform(name, (TypeInformation)compactionTaskTypeInfo, (OneInputStreamOperator)new MultiUnawareTablesReadOperator(catalogLoader, partitionIdleTime));
        }
        return source;
    }

    private static Long getPartitionInfo(Identifier tableIdentifier, BinaryRow partition, Map<Identifier, Map<BinaryRow, Long>> multiTablesPartitionInfo, Catalog catalog) {
        Map<BinaryRow, Long> partitionInfo = multiTablesPartitionInfo.get(tableIdentifier);
        if (partitionInfo == null) {
            try {
                Table table = catalog.getTable(tableIdentifier);
                if (!(table instanceof FileStoreTable)) {
                    LOGGER.error(String.format("Only FileStoreTable supports compact action. The table type is '%s'.", table.getClass().getName()));
                }
                FileStoreTable fileStoreTable = (FileStoreTable)table;
                List<PartitionEntry> partitions = fileStoreTable.newSnapshotReader().partitionEntries();
                partitionInfo = partitions.stream().collect(Collectors.toMap(PartitionEntry::partition, PartitionEntry::lastFileCreationTime));
                multiTablesPartitionInfo.put(tableIdentifier, partitionInfo);
            }
            catch (Catalog.TableNotExistException e) {
                LOGGER.error(String.format("table: %s not found.", tableIdentifier.getFullName()));
            }
        }
        return partitionInfo.get(partition);
    }

    private class Reader
    extends AbstractNonCoordinatedSourceReader<MultiTableUnawareAppendCompactionTask> {
        private transient MultiTableScanBase<MultiTableUnawareAppendCompactionTask> tableScan;

        private Reader() {
        }

        @Override
        public void start() {
            super.start();
            this.tableScan = new MultiUnawareBucketTableScan(CombinedUnawareBatchSource.this.catalogLoader, CombinedUnawareBatchSource.this.includingPattern, CombinedUnawareBatchSource.this.excludingPattern, CombinedUnawareBatchSource.this.databasePattern, CombinedUnawareBatchSource.this.isStreaming);
        }

        public InputStatus pollNext(ReaderOutput<MultiTableUnawareAppendCompactionTask> readerOutput) throws Exception {
            MultiTableScanBase.ScanResult scanResult = this.tableScan.scanTable(readerOutput);
            if (scanResult == MultiTableScanBase.ScanResult.FINISHED) {
                return InputStatus.END_OF_INPUT;
            }
            if (scanResult == MultiTableScanBase.ScanResult.IS_EMPTY) {
                LOGGER.info("No file were collected for the table of unaware-bucket");
            }
            return InputStatus.END_OF_INPUT;
        }

        @Override
        public void close() throws Exception {
            super.close();
            if (this.tableScan != null) {
                this.tableScan.close();
            }
        }
    }
}

