/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.partition;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.paimon.Snapshot;
import org.apache.paimon.fs.Path;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.metastore.MetastoreClient;
import org.apache.paimon.partition.Partition;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.ScanMode;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.utils.PartitionPathUtils;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SnapshotManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionStatisticsReporter
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionStatisticsReporter.class);
    private final MetastoreClient metastoreClient;
    private final SnapshotReader snapshotReader;
    private final SnapshotManager snapshotManager;

    public PartitionStatisticsReporter(FileStoreTable table, MetastoreClient client) {
        this.metastoreClient = Preconditions.checkNotNull(client, "the metastore client factory is null");
        this.snapshotReader = table.newSnapshotReader();
        this.snapshotManager = table.snapshotManager();
    }

    public void report(String partition, long modifyTimeMillis) throws Exception {
        Snapshot snapshot = this.snapshotManager.latestSnapshot();
        if (snapshot != null) {
            LinkedHashMap<String, String> partitionSpec = PartitionPathUtils.extractPartitionSpecFromPath(new Path(partition));
            ArrayList<DataSplit> splits = new ArrayList<DataSplit>(this.snapshotReader.withMode(ScanMode.ALL).withPartitionFilter(partitionSpec).withSnapshot(snapshot).read().dataSplits());
            long rowCount = 0L;
            long totalSize = 0L;
            long fileCount = 0L;
            for (DataSplit split : splits) {
                List<DataFileMeta> fileMetas = split.dataFiles();
                rowCount += split.rowCount();
                fileCount += (long)fileMetas.size();
                for (DataFileMeta fileMeta : fileMetas) {
                    totalSize += fileMeta.fileSize();
                }
            }
            Partition partitionStats = new Partition(partitionSpec, fileCount, totalSize, rowCount, modifyTimeMillis);
            LOG.info("alter partition {} with statistic {}.", partitionSpec, (Object)partitionStats);
            this.metastoreClient.alterPartition(partitionStats);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.metastoreClient.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

