/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.partition;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.paimon.flink.sink.Committer;
import org.apache.paimon.flink.sink.partition.PartitionListener;
import org.apache.paimon.flink.sink.partition.PartitionMarkDone;
import org.apache.paimon.flink.sink.partition.ReportPartStatsListener;
import org.apache.paimon.manifest.ManifestCommittable;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.utils.IOUtils;

public class PartitionListeners
implements Closeable {
    private final List<PartitionListener> listeners;

    private PartitionListeners(List<PartitionListener> listeners) {
        this.listeners = listeners;
    }

    public void notifyCommittable(List<ManifestCommittable> committables) {
        for (PartitionListener trigger : this.listeners) {
            trigger.notifyCommittable(committables);
        }
    }

    public void snapshotState() throws Exception {
        for (PartitionListener trigger : this.listeners) {
            trigger.snapshotState();
        }
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeAllQuietly(this.listeners);
    }

    public static PartitionListeners create(Committer.Context context, FileStoreTable table) throws Exception {
        ArrayList<PartitionListener> listeners = new ArrayList<PartitionListener>();
        ReportPartStatsListener.create(context.isRestored(), context.stateStore(), table).ifPresent(listeners::add);
        PartitionMarkDone.create(context.streamingCheckpointEnabled(), context.isRestored(), context.stateStore(), table).ifPresent(listeners::add);
        return new PartitionListeners(listeners);
    }
}

