/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.index;

import java.util.List;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.paimon.codegen.CodeGenUtils;
import org.apache.paimon.codegen.Projection;
import org.apache.paimon.crosspartition.KeyPartOrRow;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.table.sink.ChannelComputer;
import org.apache.paimon.types.RowType;

public class KeyPartRowChannelComputer
implements ChannelComputer<Tuple2<KeyPartOrRow, InternalRow>> {
    private static final long serialVersionUID = 1L;
    private final RowType rowType;
    private final RowType keyPartType;
    private final List<String> primaryKey;
    private transient int numChannels;
    private transient Projection rowProject;
    private transient Projection keyPartProject;

    public KeyPartRowChannelComputer(RowType rowType, RowType keyPartType, List<String> primaryKey) {
        this.rowType = rowType;
        this.keyPartType = keyPartType;
        this.primaryKey = primaryKey;
    }

    @Override
    public void setup(int numChannels) {
        this.numChannels = numChannels;
        this.rowProject = CodeGenUtils.newProjection(this.rowType, this.primaryKey);
        this.keyPartProject = CodeGenUtils.newProjection(this.keyPartType, this.primaryKey);
    }

    @Override
    public int channel(Tuple2<KeyPartOrRow, InternalRow> record) {
        BinaryRow key = (record.f0 == KeyPartOrRow.KEY_PART ? this.keyPartProject : this.rowProject).apply((InternalRow)record.f1);
        return Math.abs(key.hashCode() % this.numChannels);
    }

    public String toString() {
        return "shuffle by key hash";
    }
}

