/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import java.util.Map;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.streaming.api.operators.OneInputStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.flink.sink.Committable;
import org.apache.paimon.flink.sink.LogSinkFunction;
import org.apache.paimon.flink.sink.NoopStoreSinkWriteState;
import org.apache.paimon.flink.sink.RowDataStoreWriteOperator;
import org.apache.paimon.flink.sink.StoreSinkWrite;
import org.apache.paimon.flink.sink.StoreSinkWriteState;
import org.apache.paimon.flink.sink.UnawareBucketSink;
import org.apache.paimon.table.FileStoreTable;

public class RowUnawareBucketSink
extends UnawareBucketSink<InternalRow> {
    public RowUnawareBucketSink(FileStoreTable table, Map<String, String> overwritePartitions, LogSinkFunction logSinkFunction, Integer parallelism) {
        super(table, overwritePartitions, logSinkFunction, parallelism);
    }

    @Override
    protected OneInputStreamOperatorFactory<InternalRow, Committable> createWriteOperatorFactory(final StoreSinkWrite.Provider writeProvider, final String commitUser) {
        return new RowDataStoreWriteOperator.Factory(this.table, this.logSinkFunction, writeProvider, commitUser){

            public StreamOperator createStreamOperator(StreamOperatorParameters parameters) {
                return new RowDataStoreWriteOperator(parameters, this.table, RowUnawareBucketSink.this.logSinkFunction, writeProvider, commitUser){

                    @Override
                    protected StoreSinkWriteState createState(StateInitializationContext context, StoreSinkWriteState.StateValueFilter stateFilter) throws Exception {
                        return new NoopStoreSinkWriteState(stateFilter);
                    }

                    @Override
                    protected String getCommitUser(StateInitializationContext context) throws Exception {
                        return commitUser;
                    }
                };
            }
        };
    }
}

