/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.streaming.api.operators.OneInputStreamOperatorFactory;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.flink.sink.Committable;
import org.apache.paimon.flink.sink.DynamicBucketRowWriteOperator;
import org.apache.paimon.flink.sink.DynamicBucketSink;
import org.apache.paimon.flink.sink.RowAssignerChannelComputer;
import org.apache.paimon.flink.sink.RowWithBucketChannelComputer;
import org.apache.paimon.flink.sink.StoreSinkWrite;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.sink.ChannelComputer;
import org.apache.paimon.table.sink.PartitionKeyExtractor;
import org.apache.paimon.table.sink.RowPartitionKeyExtractor;
import org.apache.paimon.utils.SerializableFunction;

public class RowDynamicBucketSink
extends DynamicBucketSink<InternalRow> {
    private static final long serialVersionUID = 1L;

    public RowDynamicBucketSink(FileStoreTable table, @Nullable Map<String, String> overwritePartition) {
        super(table, overwritePartition);
    }

    @Override
    protected ChannelComputer<InternalRow> assignerChannelComputer(Integer numAssigners) {
        return new RowAssignerChannelComputer(this.table.schema(), numAssigners);
    }

    @Override
    protected ChannelComputer<Tuple2<InternalRow, Integer>> channelComputer2() {
        return new RowWithBucketChannelComputer(this.table.schema());
    }

    @Override
    protected SerializableFunction<TableSchema, PartitionKeyExtractor<InternalRow>> extractorFunction() {
        return RowPartitionKeyExtractor::new;
    }

    @Override
    protected OneInputStreamOperatorFactory<Tuple2<InternalRow, Integer>, Committable> createWriteOperatorFactory(StoreSinkWrite.Provider writeProvider, String commitUser) {
        return new DynamicBucketRowWriteOperator.Factory(this.table, writeProvider, commitUser);
    }
}

