/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import org.apache.flink.table.annotation.ArgumentHint;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.ProcedureHint;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.table.Table;

public class RenameTagProcedure
extends ProcedureBase {
    private static final String IDENTIFIER = "rename_tag";

    @ProcedureHint(argument={@ArgumentHint(name="table", type=@DataTypeHint(value="STRING")), @ArgumentHint(name="tagName", type=@DataTypeHint(value="STRING")), @ArgumentHint(name="targetTagName", type=@DataTypeHint(value="STRING"))})
    public String[] call(ProcedureContext procedureContext, String tableId, String tagName, String targetTagName) throws Catalog.TableNotExistException {
        Table table = this.catalog.getTable(Identifier.fromString(tableId));
        table.renameTag(tagName, targetTagName);
        String ret = String.format("Rename [%s] to [%s] successfully.", tagName, targetTagName);
        return new String[]{ret};
    }

    @Override
    public String identifier() {
        return IDENTIFIER;
    }
}

