/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import org.apache.flink.table.annotation.ArgumentHint;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.ProcedureHint;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.flink.utils.TableMigrationUtils;
import org.apache.paimon.utils.ParameterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrateTableProcedure
extends ProcedureBase {
    private static final Logger LOG = LoggerFactory.getLogger(MigrateTableProcedure.class);
    private static final String PAIMON_SUFFIX = "_paimon_";

    @Override
    public String identifier() {
        return "migrate_table";
    }

    @ProcedureHint(argument={@ArgumentHint(name="connector", type=@DataTypeHint(value="STRING")), @ArgumentHint(name="source_table", type=@DataTypeHint(value="STRING")), @ArgumentHint(name="options", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="parallelism", type=@DataTypeHint(value="Integer"), isOptional=true)})
    public String[] call(ProcedureContext procedureContext, String connector, String sourceTablePath, String properties, Integer parallelism) throws Exception {
        properties = this.notnull(properties);
        String targetPaimonTablePath = sourceTablePath + PAIMON_SUFFIX;
        Identifier sourceTableId = Identifier.fromString(sourceTablePath);
        Identifier targetTableId = Identifier.fromString(targetPaimonTablePath);
        Integer p = parallelism == null ? Runtime.getRuntime().availableProcessors() : parallelism.intValue();
        TableMigrationUtils.getImporter(connector, this.catalog, sourceTableId.getDatabaseName(), sourceTableId.getObjectName(), targetTableId.getDatabaseName(), targetTableId.getObjectName(), p, ParameterUtils.parseCommaSeparatedKeyValues(properties)).executeMigrate();
        LOG.info("Last step: rename " + targetTableId + " to " + sourceTableId);
        this.catalog.renameTable(targetTableId, sourceTableId, false);
        return new String[]{"Success"};
    }
}

