/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.table.annotation.ArgumentHint;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.ProcedureHint;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.flink.types.Row;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.FileStore;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.metastore.MetastoreClient;
import org.apache.paimon.operation.PartitionExpire;
import org.apache.paimon.partition.PartitionExpireStrategy;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.utils.TimeUtils;

public class ExpirePartitionsProcedure
extends ProcedureBase {
    @Override
    public String identifier() {
        return "expire_partitions";
    }

    @ProcedureHint(argument={@ArgumentHint(name="table", type=@DataTypeHint(value="STRING")), @ArgumentHint(name="expiration_time", type=@DataTypeHint(value="STRING")), @ArgumentHint(name="timestamp_formatter", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="timestamp_pattern", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="expire_strategy", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="max_expires", type=@DataTypeHint(value="INTEGER"), isOptional=true)})
    @DataTypeHint(value="ROW< expired_partitions STRING>")
    public Row[] call(ProcedureContext procedureContext, String tableId, String expirationTime, String timestampFormatter, String timestampPattern, String expireStrategy, Integer maxExpires) throws Catalog.TableNotExistException {
        Row[] rowArray;
        List<Map<String, String>> expired;
        FileStoreTable fileStoreTable = (FileStoreTable)this.table(tableId);
        FileStore<?> fileStore = fileStoreTable.store();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(CoreOptions.PARTITION_EXPIRATION_STRATEGY.key(), expireStrategy);
        map.put(CoreOptions.PARTITION_TIMESTAMP_FORMATTER.key(), timestampFormatter);
        map.put(CoreOptions.PARTITION_TIMESTAMP_PATTERN.key(), timestampPattern);
        PartitionExpire partitionExpire = new PartitionExpire(TimeUtils.parseDuration(expirationTime), Duration.ofMillis(0L), PartitionExpireStrategy.createPartitionExpireStrategy(CoreOptions.fromMap(map), fileStore.partitionType()), fileStore.newScan(), fileStore.newCommit(""), Optional.ofNullable(fileStoreTable.catalogEnvironment().metastoreClientFactory()).map(MetastoreClient.Factory::create).orElse(null), fileStore.options().partitionExpireMaxNum());
        if (maxExpires != null) {
            partitionExpire.withMaxExpireNum(maxExpires);
        }
        if ((expired = partitionExpire.expire(Long.MAX_VALUE)) == null || expired.isEmpty()) {
            Row[] rowArray2 = new Row[1];
            rowArray = rowArray2;
            rowArray2[0] = Row.of((Object[])new Object[]{"No expired partitions."});
        } else {
            rowArray = (Row[])expired.stream().map(x -> {
                String r = x.toString();
                return Row.of((Object[])new Object[]{r.substring(1, r.length() - 1)});
            }).toArray(Row[]::new);
        }
        return rowArray;
    }
}

