/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.predicate;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.paimon.flink.utils.FlinkCalciteClasses;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.TypeUtils;

public class SimpleSqlPredicateConvertor {
    private final PredicateBuilder builder;
    private final RowType rowType;
    private final FlinkCalciteClasses calciteClasses;

    public SimpleSqlPredicateConvertor(RowType type) throws Exception {
        this.rowType = type;
        this.builder = new PredicateBuilder(type);
        this.calciteClasses = new FlinkCalciteClasses();
    }

    public Predicate convertSqlToPredicate(String whereSql) throws Exception {
        Object config = this.calciteClasses.configDelegate().withLex(this.calciteClasses.sqlParserDelegate().config(), this.calciteClasses.lexDelegate().java());
        Object sqlParser = this.calciteClasses.sqlParserDelegate().create(whereSql, config);
        Object sqlBasicCall = this.calciteClasses.sqlParserDelegate().parseExpression(sqlParser);
        return this.convert(sqlBasicCall);
    }

    public Predicate convert(Object sqlBasicCall) throws Exception {
        Object operator = this.calciteClasses.sqlBasicCallDelegate().getOperator(sqlBasicCall);
        Object kind = this.calciteClasses.sqlOperatorDelegate().getKind(operator);
        if (this.calciteClasses.sqlOperatorDelegate().instanceOfSqlBinaryOperator(operator)) {
            List<?> operandList = this.calciteClasses.sqlBasicCallDelegate().getOperandList(sqlBasicCall);
            Object left = operandList.get(0);
            Object right = operandList.get(1);
            if (kind == this.calciteClasses.sqlKindDelegate().or()) {
                return PredicateBuilder.or(this.convert(left), this.convert(right));
            }
            if (kind == this.calciteClasses.sqlKindDelegate().and()) {
                return PredicateBuilder.and(this.convert(left), this.convert(right));
            }
            if (kind == this.calciteClasses.sqlKindDelegate().equals()) {
                return this.visitBiFunction(left, right, this.builder::equal, this.builder::equal);
            }
            if (kind == this.calciteClasses.sqlKindDelegate().notEquals()) {
                return this.visitBiFunction(left, right, this.builder::notEqual, this.builder::notEqual);
            }
            if (kind == this.calciteClasses.sqlKindDelegate().lessThan()) {
                return this.visitBiFunction(left, right, this.builder::lessThan, this.builder::greaterThan);
            }
            if (kind == this.calciteClasses.sqlKindDelegate().lessThanOrEqual()) {
                return this.visitBiFunction(left, right, this.builder::lessOrEqual, this.builder::greaterOrEqual);
            }
            if (kind == this.calciteClasses.sqlKindDelegate().greaterThan()) {
                return this.visitBiFunction(left, right, this.builder::greaterThan, this.builder::lessThan);
            }
            if (kind == this.calciteClasses.sqlKindDelegate().greaterThanOrEqual()) {
                return this.visitBiFunction(left, right, this.builder::greaterOrEqual, this.builder::lessOrEqual);
            }
            if (kind == this.calciteClasses.sqlKindDelegate().in()) {
                int index = this.getFieldIndex(left.toString());
                List<?> elementslist = this.calciteClasses.sqlNodeListDelegate().getList(right);
                ArrayList<Object> list = new ArrayList<Object>();
                for (Object sqlNode : elementslist) {
                    Object literal = TypeUtils.castFromString(this.calciteClasses.sqlLiteralDelegate().toValue(sqlNode), this.rowType.getFieldTypes().get(index));
                    list.add(literal);
                }
                return this.builder.in(index, list);
            }
        } else if (this.calciteClasses.sqlOperatorDelegate().instanceOfSqlPostfixOperator(operator)) {
            Object child = this.calciteClasses.sqlBasicCallDelegate().getOperandList(sqlBasicCall).get(0);
            if (kind == this.calciteClasses.sqlKindDelegate().isNull()) {
                String field = String.valueOf(child);
                return this.builder.isNull(this.getFieldIndex(field));
            }
            if (kind == this.calciteClasses.sqlKindDelegate().isNotNull()) {
                String field = String.valueOf(child);
                return this.builder.isNotNull(this.getFieldIndex(field));
            }
        } else if (this.calciteClasses.sqlOperatorDelegate().instanceOfSqlPrefixOperator(operator) && kind == this.calciteClasses.sqlKindDelegate().not()) {
            return this.convert(this.calciteClasses.sqlBasicCallDelegate().getOperandList(sqlBasicCall).get(0)).negate().get();
        }
        throw new UnsupportedOperationException(String.format("%s not been supported.", kind));
    }

    public Predicate visitBiFunction(Object left, Object right, BiFunction<Integer, Object, Predicate> visitLeft, BiFunction<Integer, Object, Predicate> visitRight) throws Exception {
        if (this.calciteClasses.sqlIndentifierDelegate().instanceOfSqlIdentifier(left) && this.calciteClasses.sqlLiteralDelegate().instanceOfSqlLiteral(right)) {
            int index = this.getFieldIndex(String.valueOf(left));
            String value = this.calciteClasses.sqlLiteralDelegate().toValue(right);
            DataType type = this.rowType.getFieldTypes().get(index);
            return visitLeft.apply(index, TypeUtils.castFromString(value, type));
        }
        if (this.calciteClasses.sqlIndentifierDelegate().instanceOfSqlIdentifier(right) && this.calciteClasses.sqlLiteralDelegate().instanceOfSqlLiteral(left)) {
            int index = this.getFieldIndex(right.toString());
            return visitRight.apply(index, TypeUtils.castFromString(this.calciteClasses.sqlLiteralDelegate().toValue(left), this.rowType.getFieldTypes().get(index)));
        }
        throw new UnsupportedOperationException(String.format("%s or %s not been supported.", left, right));
    }

    public int getFieldIndex(String field) {
        int index = this.builder.indexOf(field);
        if (index == -1) {
            throw new RuntimeException(String.format("Field `%s` not found", field));
        }
        return index;
    }
}

