/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Map;
import org.apache.paimon.Snapshot;
import org.apache.paimon.flink.action.TableActionBase;
import org.apache.paimon.table.DataTable;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RollbackToTimestampAction
extends TableActionBase {
    private static final Logger LOG = LoggerFactory.getLogger(RollbackToTimestampAction.class);
    private final Long timestamp;

    public RollbackToTimestampAction(String databaseName, String tableName, Long timestamp, Map<String, String> catalogConfig) {
        super(databaseName, tableName, catalogConfig);
        this.timestamp = timestamp;
    }

    @Override
    public void run() throws Exception {
        LOG.debug("Run rollback-to-timestamp action with timestamp '{}'.", (Object)this.timestamp);
        if (!(this.table instanceof DataTable)) {
            throw new IllegalArgumentException("Unknown table: " + this.identifier);
        }
        FileStoreTable fileStoreTable = (FileStoreTable)this.table;
        Snapshot snapshot = fileStoreTable.snapshotManager().earlierOrEqualTimeMills(this.timestamp);
        Preconditions.checkNotNull(snapshot, String.format("count not find snapshot earlier than %s", this.timestamp));
        fileStoreTable.rollbackTo(snapshot.id());
    }
}

