/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data.columnar.heap;

import java.util.Arrays;
import org.apache.paimon.data.columnar.heap.AbstractHeapVector;
import org.apache.paimon.data.columnar.writable.WritableByteVector;

public class HeapByteVector
extends AbstractHeapVector
implements WritableByteVector {
    private static final long serialVersionUID = 7216045902943789034L;
    public byte[] vector;

    public HeapByteVector(int len) {
        super(len);
        this.vector = new byte[len];
    }

    @Override
    public byte getByte(int i) {
        if (this.dictionary == null) {
            return this.vector[i];
        }
        return (byte)this.dictionary.decodeToInt(this.dictionaryIds.vector[i]);
    }

    @Override
    public void setByte(int i, byte value) {
        this.vector[i] = value;
    }

    @Override
    public void fill(byte value) {
        Arrays.fill(this.vector, value);
    }

    @Override
    void reserveForHeapVector(int newCapacity) {
        if (this.vector.length < newCapacity) {
            this.vector = Arrays.copyOf(this.vector, newCapacity);
        }
    }

    @Override
    public void reset() {
        super.reset();
        if (this.vector.length != this.capacity) {
            this.vector = new byte[this.capacity];
        } else {
            Arrays.fill(this.vector, (byte)0);
        }
    }
}

