/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data;

import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.DataGetters;
import org.apache.paimon.data.DataSetters;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeChecks;
import org.apache.paimon.types.RowKind;

@Public
public interface InternalRow
extends DataGetters {
    public int getFieldCount();

    public RowKind getRowKind();

    public void setRowKind(RowKind var1);

    public static Class<?> getDataClass(DataType type) {
        switch (type.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: {
                return BinaryString.class;
            }
            case BOOLEAN: {
                return Boolean.class;
            }
            case BINARY: 
            case VARBINARY: {
                return byte[].class;
            }
            case DECIMAL: {
                return Decimal.class;
            }
            case TINYINT: {
                return Byte.class;
            }
            case SMALLINT: {
                return Short.class;
            }
            case INTEGER: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: {
                return Integer.class;
            }
            case BIGINT: {
                return Long.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case DOUBLE: {
                return Double.class;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return Timestamp.class;
            }
            case ARRAY: {
                return InternalArray.class;
            }
            case MULTISET: 
            case MAP: {
                return InternalMap.class;
            }
            case ROW: {
                return InternalRow.class;
            }
        }
        throw new IllegalArgumentException("Illegal type: " + type);
    }

    public static FieldGetter createFieldGetter(DataType fieldType, int fieldPos) {
        FieldGetter fieldGetter;
        switch (fieldType.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: {
                fieldGetter = row -> row.getString(fieldPos);
                break;
            }
            case BOOLEAN: {
                fieldGetter = row -> row.getBoolean(fieldPos);
                break;
            }
            case BINARY: 
            case VARBINARY: {
                fieldGetter = row -> row.getBinary(fieldPos);
                break;
            }
            case DECIMAL: {
                int decimalPrecision = DataTypeChecks.getPrecision(fieldType);
                int decimalScale = DataTypeChecks.getScale(fieldType);
                fieldGetter = row -> row.getDecimal(fieldPos, decimalPrecision, decimalScale);
                break;
            }
            case TINYINT: {
                fieldGetter = row -> row.getByte(fieldPos);
                break;
            }
            case SMALLINT: {
                fieldGetter = row -> row.getShort(fieldPos);
                break;
            }
            case INTEGER: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: {
                fieldGetter = row -> row.getInt(fieldPos);
                break;
            }
            case BIGINT: {
                fieldGetter = row -> row.getLong(fieldPos);
                break;
            }
            case FLOAT: {
                fieldGetter = row -> Float.valueOf(row.getFloat(fieldPos));
                break;
            }
            case DOUBLE: {
                fieldGetter = row -> row.getDouble(fieldPos);
                break;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                int timestampPrecision = DataTypeChecks.getPrecision(fieldType);
                fieldGetter = row -> row.getTimestamp(fieldPos, timestampPrecision);
                break;
            }
            case ARRAY: {
                fieldGetter = row -> row.getArray(fieldPos);
                break;
            }
            case MULTISET: 
            case MAP: {
                fieldGetter = row -> row.getMap(fieldPos);
                break;
            }
            case ROW: {
                int rowFieldCount = DataTypeChecks.getFieldCount(fieldType);
                fieldGetter = row -> row.getRow(fieldPos, rowFieldCount);
                break;
            }
            default: {
                String msg = String.format("type %s not support in %s", fieldType.getTypeRoot().toString(), InternalRow.class.getName());
                throw new IllegalArgumentException(msg);
            }
        }
        if (!fieldType.isNullable()) {
            return fieldGetter;
        }
        return row -> {
            if (row.isNullAt(fieldPos)) {
                return null;
            }
            return fieldGetter.getFieldOrNull(row);
        };
    }

    public static FieldSetter createFieldSetter(DataType fieldType, int fieldPos) {
        FieldSetter fieldSetter;
        switch (fieldType.getTypeRoot()) {
            case BOOLEAN: {
                fieldSetter = (from, to) -> to.setBoolean(fieldPos, from.getBoolean(fieldPos));
                break;
            }
            case DECIMAL: {
                int decimalPrecision = DataTypeChecks.getPrecision(fieldType);
                int decimalScale = DataTypeChecks.getScale(fieldType);
                fieldSetter = (from, to) -> to.setDecimal(fieldPos, from.getDecimal(fieldPos, decimalPrecision, decimalScale), decimalPrecision);
                if (!fieldType.isNullable() || Decimal.isCompact(decimalPrecision)) break;
                return (from, to) -> {
                    if (from.isNullAt(fieldPos)) {
                        to.setNullAt(fieldPos);
                        to.setDecimal(fieldPos, null, decimalPrecision);
                    } else {
                        fieldSetter.setFieldFrom(from, to);
                    }
                };
            }
            case TINYINT: {
                fieldSetter = (from, to) -> to.setByte(fieldPos, from.getByte(fieldPos));
                break;
            }
            case SMALLINT: {
                fieldSetter = (from, to) -> to.setShort(fieldPos, from.getShort(fieldPos));
                break;
            }
            case INTEGER: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: {
                fieldSetter = (from, to) -> to.setInt(fieldPos, from.getInt(fieldPos));
                break;
            }
            case BIGINT: {
                fieldSetter = (from, to) -> to.setLong(fieldPos, from.getLong(fieldPos));
                break;
            }
            case FLOAT: {
                fieldSetter = (from, to) -> to.setFloat(fieldPos, from.getFloat(fieldPos));
                break;
            }
            case DOUBLE: {
                fieldSetter = (from, to) -> to.setDouble(fieldPos, from.getDouble(fieldPos));
                break;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                int timestampPrecision = DataTypeChecks.getPrecision(fieldType);
                fieldSetter = (from, to) -> to.setTimestamp(fieldPos, from.getTimestamp(fieldPos, timestampPrecision), timestampPrecision);
                if (!fieldType.isNullable() || Timestamp.isCompact(timestampPrecision)) break;
                return (from, to) -> {
                    if (from.isNullAt(fieldPos)) {
                        to.setNullAt(fieldPos);
                        to.setTimestamp(fieldPos, null, timestampPrecision);
                    } else {
                        fieldSetter.setFieldFrom(from, to);
                    }
                };
            }
            default: {
                throw new IllegalArgumentException(String.format("type %s not support for setting", fieldType));
            }
        }
        if (!fieldType.isNullable()) {
            return fieldSetter;
        }
        return (from, to) -> {
            if (from.isNullAt(fieldPos)) {
                to.setNullAt(fieldPos);
            } else {
                fieldSetter.setFieldFrom(from, to);
            }
        };
    }

    public static interface FieldSetter
    extends Serializable {
        public void setFieldFrom(DataGetters var1, DataSetters var2);
    }

    public static interface FieldGetter
    extends Serializable {
        @Nullable
        public Object getFieldOrNull(InternalRow var1);
    }
}

