/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon;

import org.apache.paimon.options.description.DescribedEnum;
import org.apache.paimon.options.description.InlineElement;
import org.apache.paimon.options.description.TextElement;

public enum TableType implements DescribedEnum
{
    TABLE("table", "Normal Paimon table."),
    FORMAT_TABLE("format-table", "A file format table refers to a directory that contains multiple files of the same format."),
    MATERIALIZED_TABLE("materialized-table", "A materialized table combines normal Paimon table and materialized SQL."),
    OBJECT_TABLE("object-table", "A object table combines normal Paimon table and object location.");

    private final String value;
    private final String description;

    private TableType(String value, String description) {
        this.value = value;
        this.description = description;
    }

    public String toString() {
        return this.value;
    }

    @Override
    public InlineElement getDescription() {
        return TextElement.text(this.description);
    }

    public static TableType fromString(String name) {
        for (TableType type : TableType.values()) {
            if (!type.value.equals(name)) continue;
            return type;
        }
        throw new UnsupportedOperationException("Unknown table type: " + name);
    }
}

