/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.data.Segments;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.Cache;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.Caffeine;

public class SegmentsCache<T> {
    private static final int OBJECT_MEMORY_SIZE = 1000;
    private final int pageSize;
    private final Cache<T, Segments> cache;
    private final MemorySize maxMemorySize;
    private final long maxElementSize;

    public SegmentsCache(int pageSize, MemorySize maxMemorySize, long maxElementSize) {
        this.pageSize = pageSize;
        this.cache = Caffeine.newBuilder().softValues().weigher(this::weigh).maximumWeight(maxMemorySize.getBytes()).executor(Runnable::run).build();
        this.maxMemorySize = maxMemorySize;
        this.maxElementSize = maxElementSize;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public MemorySize maxMemorySize() {
        return this.maxMemorySize;
    }

    public long maxElementSize() {
        return this.maxElementSize;
    }

    @Nullable
    public Segments getIfPresents(T key) {
        return this.cache.getIfPresent(key);
    }

    public void put(T key, Segments segments) {
        this.cache.put(key, segments);
    }

    private int weigh(T cacheKey, Segments segments) {
        return 1000 + segments.segments().size() * this.pageSize;
    }

    @Nullable
    public static <T> SegmentsCache<T> create(MemorySize maxMemorySize, long maxElementSize) {
        return SegmentsCache.create((int)CoreOptions.PAGE_SIZE.defaultValue().getBytes(), maxMemorySize, maxElementSize);
    }

    @Nullable
    public static <T> SegmentsCache<T> create(int pageSize, MemorySize maxMemorySize, long maxElementSize) {
        if (maxMemorySize.getBytes() == 0L) {
            return null;
        }
        return new SegmentsCache<T>(pageSize, maxMemorySize, maxElementSize);
    }
}

