/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.util.Iterator;
import javax.annotation.Nullable;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.fs.Path;
import org.apache.paimon.reader.FileRecordIterator;
import org.apache.paimon.utils.RecyclableIterator;

public final class IteratorResultIterator
extends RecyclableIterator<InternalRow>
implements FileRecordIterator<InternalRow> {
    private final Iterator<InternalRow> records;
    private final Path filePath;
    private long nextFilePos;

    public IteratorResultIterator(Iterator<InternalRow> records, @Nullable Runnable recycler, Path filePath, long pos) {
        super(recycler);
        this.records = records;
        this.filePath = filePath;
        this.nextFilePos = pos;
    }

    @Override
    @Nullable
    public InternalRow next() {
        if (this.records.hasNext()) {
            ++this.nextFilePos;
            return this.records.next();
        }
        return null;
    }

    @Override
    public long returnedPosition() {
        return this.nextFilePos - 1L;
    }

    @Override
    public Path filePath() {
        return this.filePath;
    }
}

