/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.paimon.Snapshot;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.FileStatus;
import org.apache.paimon.fs.Path;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.utils.FileUtils;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.StringUtils;
import org.apache.paimon.utils.TagManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BranchManager {
    private static final Logger LOG = LoggerFactory.getLogger(BranchManager.class);
    public static final String BRANCH_PREFIX = "branch-";
    public static final String DEFAULT_MAIN_BRANCH = "main";
    private final FileIO fileIO;
    private final Path tablePath;
    private final SnapshotManager snapshotManager;
    private final TagManager tagManager;
    private final SchemaManager schemaManager;

    public BranchManager(FileIO fileIO, Path path, SnapshotManager snapshotManager, TagManager tagManager, SchemaManager schemaManager) {
        this.fileIO = fileIO;
        this.tablePath = path;
        this.snapshotManager = snapshotManager;
        this.tagManager = tagManager;
        this.schemaManager = schemaManager;
    }

    public Path branchDirectory() {
        return new Path(this.tablePath + "/branch");
    }

    public static boolean isMainBranch(String branch) {
        return branch.equals(DEFAULT_MAIN_BRANCH);
    }

    public static String branchPath(Path tablePath, String branch) {
        return BranchManager.isMainBranch(branch) ? tablePath.toString() : tablePath.toString() + "/branch/" + BRANCH_PREFIX + branch;
    }

    public Path branchPath(String branchName) {
        return new Path(BranchManager.branchPath(this.tablePath, branchName));
    }

    public void createBranch(String branchName) {
        Preconditions.checkArgument(!BranchManager.isMainBranch(branchName), String.format("Branch name '%s' is the default branch and cannot be used.", DEFAULT_MAIN_BRANCH));
        Preconditions.checkArgument(!StringUtils.isBlank(branchName), "Branch name '%s' is blank.", branchName);
        Preconditions.checkArgument(!this.branchExists(branchName), "Branch name '%s' already exists.", branchName);
        Preconditions.checkArgument(!branchName.chars().allMatch(Character::isDigit), "Branch name cannot be pure numeric string but is '%s'.", branchName);
        try {
            TableSchema latestSchema = this.schemaManager.latest().get();
            this.fileIO.copyFile(this.schemaManager.toSchemaPath(latestSchema.id()), this.schemaManager.copyWithBranch(branchName).toSchemaPath(latestSchema.id()), true);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Exception occurs when create branch '%s' (directory in %s).", branchName, BranchManager.branchPath(this.tablePath, branchName)), e);
        }
    }

    public void createBranch(String branchName, String tagName) {
        Preconditions.checkArgument(!BranchManager.isMainBranch(branchName), String.format("Branch name '%s' is the default branch and cannot be created.", DEFAULT_MAIN_BRANCH));
        Preconditions.checkArgument(!StringUtils.isBlank(branchName), "Branch name '%s' is blank.", branchName);
        Preconditions.checkArgument(!this.branchExists(branchName), "Branch name '%s' already exists.", branchName);
        Preconditions.checkArgument(this.tagManager.tagExists(tagName), "Tag name '%s' not exists.", tagName);
        Preconditions.checkArgument(!branchName.chars().allMatch(Character::isDigit), "Branch name cannot be pure numeric string but is '%s'.", branchName);
        Snapshot snapshot = this.tagManager.taggedSnapshot(tagName);
        try {
            this.fileIO.copyFile(this.tagManager.tagPath(tagName), this.tagManager.copyWithBranch(branchName).tagPath(tagName), true);
            this.fileIO.copyFile(this.snapshotManager.snapshotPath(snapshot.id()), this.snapshotManager.copyWithBranch(branchName).snapshotPath(snapshot.id()), true);
            this.fileIO.copyFile(this.schemaManager.toSchemaPath(snapshot.schemaId()), this.schemaManager.copyWithBranch(branchName).toSchemaPath(snapshot.schemaId()), true);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Exception occurs when create branch '%s' (directory in %s).", branchName, BranchManager.branchPath(this.tablePath, branchName)), e);
        }
    }

    public void deleteBranch(String branchName) {
        Preconditions.checkArgument(this.branchExists(branchName), "Branch name '%s' doesn't exist.", branchName);
        try {
            this.fileIO.delete(this.branchPath(branchName), true);
        }
        catch (IOException e) {
            LOG.info(String.format("Deleting the branch failed due to an exception in deleting the directory %s. Please try again.", BranchManager.branchPath(this.tablePath, branchName)), (Throwable)e);
        }
    }

    public boolean fileExists(Path path) {
        try {
            return this.fileIO.exists(path);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to determine if path '%s' exists.", path), e);
        }
    }

    public void fastForward(String branchName) {
        Preconditions.checkArgument(!branchName.equals(DEFAULT_MAIN_BRANCH), "Branch name '%s' do not use in fast-forward.", branchName);
        Preconditions.checkArgument(!StringUtils.isBlank(branchName), "Branch name '%s' is blank.", branchName);
        Preconditions.checkArgument(this.branchExists(branchName), "Branch name '%s' doesn't exist.", branchName);
        Long earliestSnapshotId = this.snapshotManager.copyWithBranch(branchName).earliestSnapshotId();
        Snapshot earliestSnapshot = this.snapshotManager.copyWithBranch(branchName).snapshot(earliestSnapshotId);
        long earliestSchemaId = earliestSnapshot.schemaId();
        try {
            List deleteSnapshotPaths = FileUtils.listVersionedFileStatus(this.fileIO, this.snapshotManager.snapshotDirectory(), "snapshot-").map(FileStatus::getPath).filter(path -> Snapshot.fromPath(this.fileIO, path).id() >= earliestSnapshotId).collect(Collectors.toList());
            List deleteSchemaPaths = FileUtils.listVersionedFileStatus(this.fileIO, this.schemaManager.schemaDirectory(), "schema-").map(FileStatus::getPath).filter(path -> TableSchema.fromPath(this.fileIO, path).id() >= earliestSchemaId).collect(Collectors.toList());
            List deleteTagPaths = FileUtils.listVersionedFileStatus(this.fileIO, this.tagManager.tagDirectory(), "tag-").map(FileStatus::getPath).filter(path -> Snapshot.fromPath(this.fileIO, path).id() >= earliestSnapshotId).collect(Collectors.toList());
            List<Path> deletePaths = Stream.concat(Stream.concat(deleteSnapshotPaths.stream(), deleteSchemaPaths.stream()), deleteTagPaths.stream()).collect(Collectors.toList());
            this.snapshotManager.deleteLatestHint();
            this.fileIO.deleteFilesQuietly(deletePaths);
            this.fileIO.copyFiles(this.snapshotManager.copyWithBranch(branchName).snapshotDirectory(), this.snapshotManager.snapshotDirectory(), true);
            this.fileIO.copyFiles(this.schemaManager.copyWithBranch(branchName).schemaDirectory(), this.schemaManager.schemaDirectory(), true);
            this.fileIO.copyFiles(this.tagManager.copyWithBranch(branchName).tagDirectory(), this.tagManager.tagDirectory(), true);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Exception occurs when fast forward '%s' (directory in %s).", branchName, BranchManager.branchPath(this.tablePath, branchName)), e);
        }
    }

    public boolean branchExists(String branchName) {
        Path branchPath = this.branchPath(branchName);
        return this.fileExists(branchPath);
    }

    public List<String> branches() {
        try {
            return FileUtils.listVersionedDirectories(this.fileIO, this.branchDirectory(), BRANCH_PREFIX).map(status -> status.getPath().getName().substring(BRANCH_PREFIX.length())).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

