/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source.snapshot;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.paimon.Snapshot;
import org.apache.paimon.consumer.ConsumerManager;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.PartitionEntry;
import org.apache.paimon.metrics.MetricRegistry;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.ScanMode;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.SplitGenerator;
import org.apache.paimon.table.source.TableScan;
import org.apache.paimon.utils.Filter;
import org.apache.paimon.utils.SnapshotManager;

public interface SnapshotReader {
    public SnapshotManager snapshotManager();

    public ConsumerManager consumerManager();

    public SplitGenerator splitGenerator();

    public SnapshotReader withSnapshot(long var1);

    public SnapshotReader withSnapshot(Snapshot var1);

    public SnapshotReader withFilter(Predicate var1);

    public SnapshotReader withPartitionFilter(Map<String, String> var1);

    public SnapshotReader withPartitionFilter(Predicate var1);

    public SnapshotReader withPartitionFilter(List<BinaryRow> var1);

    public SnapshotReader withMode(ScanMode var1);

    public SnapshotReader withLevelFilter(Filter<Integer> var1);

    public SnapshotReader withManifestEntryFilter(Filter<ManifestEntry> var1);

    public SnapshotReader withBucket(int var1);

    public SnapshotReader withBucketFilter(Filter<Integer> var1);

    public SnapshotReader withDataFileNameFilter(Filter<String> var1);

    public SnapshotReader withShard(int var1, int var2);

    public SnapshotReader withMetricRegistry(MetricRegistry var1);

    public Plan read();

    public Plan readChanges();

    public Plan readIncrementalDiff(Snapshot var1);

    public List<BinaryRow> partitions();

    public List<PartitionEntry> partitionEntries();

    public static interface Plan
    extends TableScan.Plan {
        @Nullable
        public Long watermark();

        @Nullable
        public Long snapshotId();

        @Override
        public List<Split> splits();

        default public List<DataSplit> dataSplits() {
            return this.splits();
        }
    }
}

