/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.stats;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.stats.Statistics;
import org.apache.paimon.utils.PathFactory;

public class StatsFile {
    private final FileIO fileIO;
    private final PathFactory pathFactory;

    public StatsFile(FileIO fileIO, PathFactory pathFactory) {
        this.fileIO = fileIO;
        this.pathFactory = pathFactory;
    }

    public Statistics read(String fileName) {
        return Statistics.fromPath(this.fileIO, this.pathFactory.toPath(fileName));
    }

    public String write(Statistics stats) {
        Path path = this.pathFactory.newPath();
        try {
            this.fileIO.writeFile(path, stats.toJson(), false);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write stats file: " + path, e);
        }
        return path.getName();
    }

    public void delete(String fileName) {
        this.fileIO.deleteQuietly(this.pathFactory.toPath(fileName));
    }

    public boolean exists(String fileName) {
        try {
            return this.fileIO.exists(this.pathFactory.toPath(fileName));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

