/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.ManifestFile;
import org.apache.paimon.manifest.ManifestList;
import org.apache.paimon.operation.AbstractFileStoreScan;
import org.apache.paimon.operation.ScanBucketFilter;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.schema.KeyValueFieldsExtractor;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.stats.SimpleStats;
import org.apache.paimon.stats.SimpleStatsConverter;
import org.apache.paimon.stats.SimpleStatsConverters;
import org.apache.paimon.table.source.ScanMode;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.SnapshotManager;

public class KeyValueFileStoreScan
extends AbstractFileStoreScan {
    private final SimpleStatsConverters fieldKeyStatsConverters;
    private final SimpleStatsConverters fieldValueStatsConverters;
    private Predicate keyFilter;
    private Predicate valueFilter;
    private final boolean deletionVectorsEnabled;
    private final CoreOptions.MergeEngine mergeEngine;
    private final CoreOptions.ChangelogProducer changelogProducer;

    public KeyValueFileStoreScan(RowType partitionType, ScanBucketFilter bucketFilter, SnapshotManager snapshotManager, SchemaManager schemaManager, TableSchema schema, KeyValueFieldsExtractor keyValueFieldsExtractor, ManifestFile.Factory manifestFileFactory, ManifestList.Factory manifestListFactory, int numOfBuckets, boolean checkNumOfBuckets, Integer scanManifestParallelism, boolean deletionVectorsEnabled, CoreOptions.MergeEngine mergeEngine, CoreOptions.ChangelogProducer changelogProducer) {
        super(partitionType, bucketFilter, snapshotManager, schemaManager, schema, manifestFileFactory, manifestListFactory, numOfBuckets, checkNumOfBuckets, scanManifestParallelism);
        this.fieldKeyStatsConverters = new SimpleStatsConverters(sid -> keyValueFieldsExtractor.keyFields(this.scanTableSchema((long)sid)), schema.id());
        this.fieldValueStatsConverters = new SimpleStatsConverters(sid -> keyValueFieldsExtractor.valueFields(this.scanTableSchema((long)sid)), schema.id());
        this.deletionVectorsEnabled = deletionVectorsEnabled;
        this.mergeEngine = mergeEngine;
        this.changelogProducer = changelogProducer;
    }

    public KeyValueFileStoreScan withKeyFilter(Predicate predicate) {
        this.keyFilter = predicate;
        this.bucketKeyFilter.pushdown(predicate);
        return this;
    }

    public KeyValueFileStoreScan withValueFilter(Predicate predicate) {
        this.valueFilter = predicate;
        return this;
    }

    @Override
    protected boolean filterByStats(ManifestEntry entry) {
        Predicate filter = null;
        SimpleStatsConverter serializer = null;
        SimpleStats stats = null;
        if (this.isValueFilterEnabled(entry)) {
            filter = this.valueFilter;
            serializer = this.fieldValueStatsConverters.getOrCreate(entry.file().schemaId());
            stats = entry.file().valueStats();
        }
        if (filter == null && this.keyFilter != null) {
            filter = this.keyFilter;
            serializer = this.fieldKeyStatsConverters.getOrCreate(entry.file().schemaId());
            stats = entry.file().keyStats();
        }
        if (filter == null) {
            return true;
        }
        return filter.test(entry.file().rowCount(), serializer.evolution(stats.minValues()), serializer.evolution(stats.maxValues()), serializer.evolution(stats.nullCounts(), entry.file().rowCount()));
    }

    private boolean isValueFilterEnabled(ManifestEntry entry) {
        if (this.valueFilter == null) {
            return false;
        }
        switch (this.scanMode) {
            case ALL: {
                return (this.deletionVectorsEnabled || this.mergeEngine == CoreOptions.MergeEngine.FIRST_ROW) && entry.level() > 0;
            }
            case DELTA: {
                return false;
            }
            case CHANGELOG: {
                return this.changelogProducer == CoreOptions.ChangelogProducer.LOOKUP || this.changelogProducer == CoreOptions.ChangelogProducer.FULL_COMPACTION;
            }
        }
        throw new UnsupportedOperationException("Unsupported scan mode: " + (Object)((Object)this.scanMode));
    }

    @Override
    protected List<ManifestEntry> filterWholeBucketByStats(List<ManifestEntry> entries) {
        if (this.valueFilter == null || this.scanMode != ScanMode.ALL) {
            return entries;
        }
        return KeyValueFileStoreScan.noOverlapping(entries) ? this.filterWholeBucketPerFile(entries) : this.filterWholeBucketAllFiles(entries);
    }

    private List<ManifestEntry> filterWholeBucketPerFile(List<ManifestEntry> entries) {
        ArrayList<ManifestEntry> filtered = new ArrayList<ManifestEntry>();
        for (ManifestEntry entry : entries) {
            if (!this.filterByValueFilter(entry)) continue;
            filtered.add(entry);
        }
        return filtered;
    }

    private List<ManifestEntry> filterWholeBucketAllFiles(List<ManifestEntry> entries) {
        if (!(this.deletionVectorsEnabled || this.mergeEngine != CoreOptions.MergeEngine.PARTIAL_UPDATE && this.mergeEngine != CoreOptions.MergeEngine.AGGREGATE)) {
            return entries;
        }
        for (ManifestEntry entry : entries) {
            if (!this.filterByValueFilter(entry)) continue;
            return entries;
        }
        return Collections.emptyList();
    }

    private boolean filterByValueFilter(ManifestEntry entry) {
        SimpleStatsConverter serializer = this.fieldValueStatsConverters.getOrCreate(entry.file().schemaId());
        SimpleStats stats = entry.file().valueStats();
        return this.valueFilter.test(entry.file().rowCount(), serializer.evolution(stats.minValues()), serializer.evolution(stats.maxValues()), serializer.evolution(stats.nullCounts(), entry.file().rowCount()));
    }

    private static boolean noOverlapping(List<ManifestEntry> entries) {
        if (entries.size() <= 1) {
            return true;
        }
        Integer previousLevel = null;
        for (ManifestEntry entry : entries) {
            int level = entry.file().level();
            if (level == 0) {
                return false;
            }
            if (previousLevel == null) {
                previousLevel = level;
                continue;
            }
            if (previousLevel == level) continue;
            return false;
        }
        return true;
    }
}

