/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.paimon.fileindex.FileIndexPredicate;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.ManifestFile;
import org.apache.paimon.manifest.ManifestList;
import org.apache.paimon.operation.AbstractFileStoreScan;
import org.apache.paimon.operation.ScanBucketFilter;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.stats.SimpleStats;
import org.apache.paimon.stats.SimpleStatsConverter;
import org.apache.paimon.stats.SimpleStatsConverters;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.SnapshotManager;

public class AppendOnlyFileStoreScan
extends AbstractFileStoreScan {
    private final SimpleStatsConverters simpleStatsConverters;
    private final boolean fileIndexReadEnabled;
    private Predicate filter;
    private final Map<Long, Predicate> dataFilterMapping = new HashMap<Long, Predicate>();

    public AppendOnlyFileStoreScan(RowType partitionType, ScanBucketFilter bucketFilter, SnapshotManager snapshotManager, SchemaManager schemaManager, TableSchema schema, ManifestFile.Factory manifestFileFactory, ManifestList.Factory manifestListFactory, int numOfBuckets, boolean checkNumOfBuckets, Integer scanManifestParallelism, boolean fileIndexReadEnabled) {
        super(partitionType, bucketFilter, snapshotManager, schemaManager, schema, manifestFileFactory, manifestListFactory, numOfBuckets, checkNumOfBuckets, scanManifestParallelism);
        this.simpleStatsConverters = new SimpleStatsConverters(sid -> this.scanTableSchema((long)sid).fields(), schema.id());
        this.fileIndexReadEnabled = fileIndexReadEnabled;
    }

    public AppendOnlyFileStoreScan withFilter(Predicate predicate) {
        this.filter = predicate;
        this.bucketKeyFilter.pushdown(predicate);
        return this;
    }

    @Override
    protected boolean filterByStats(ManifestEntry entry) {
        if (this.filter == null) {
            return true;
        }
        SimpleStatsConverter serializer = this.simpleStatsConverters.getOrCreate(entry.file().schemaId());
        SimpleStats stats = entry.file().valueStats();
        return this.filter.test(entry.file().rowCount(), serializer.evolution(stats.minValues()), serializer.evolution(stats.maxValues()), serializer.evolution(stats.nullCounts(), entry.file().rowCount())) && (!this.fileIndexReadEnabled || this.testFileIndex(entry.file().embeddedIndex(), entry));
    }

    @Override
    protected List<ManifestEntry> filterWholeBucketByStats(List<ManifestEntry> entries) {
        return entries;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean testFileIndex(@Nullable byte[] embeddedIndexBytes, ManifestEntry entry) {
        if (embeddedIndexBytes == null) {
            return true;
        }
        RowType dataRowType = this.scanTableSchema(entry.file().schemaId()).logicalRowType();
        Predicate dataPredicate = this.dataFilterMapping.computeIfAbsent(entry.file().schemaId(), id -> this.simpleStatsConverters.convertFilter(entry.file().schemaId(), this.filter));
        try (FileIndexPredicate predicate = new FileIndexPredicate(embeddedIndexBytes, dataRowType);){
            boolean bl = predicate.testPredicate(dataPredicate);
            return bl;
        }
        catch (IOException e) {
            throw new RuntimeException("Exception happens while checking predicate.", e);
        }
    }
}

