/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.metastore;

import java.util.List;
import java.util.Optional;
import org.apache.paimon.Snapshot;
import org.apache.paimon.manifest.ManifestCommittable;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.metastore.AddPartitionTagCallback;
import org.apache.paimon.table.sink.CommitCallback;
import org.apache.paimon.tag.TagPreview;

public class TagPreviewCommitCallback
implements CommitCallback {
    private final AddPartitionTagCallback tagCallback;
    private final TagPreview tagPreview;

    public TagPreviewCommitCallback(AddPartitionTagCallback tagCallback, TagPreview tagPreview) {
        this.tagCallback = tagCallback;
        this.tagPreview = tagPreview;
    }

    @Override
    public void call(List<ManifestEntry> committedEntries, Snapshot snapshot) {
        long currentMillis = System.currentTimeMillis();
        Optional<String> tagOptional = this.tagPreview.extractTag(currentMillis, snapshot.watermark());
        tagOptional.ifPresent(this.tagCallback::notifyCreation);
    }

    @Override
    public void retry(ManifestCommittable committable) {
        long currentMillis = System.currentTimeMillis();
        Optional<String> tagOptional = this.tagPreview.extractTag(currentMillis, committable.watermark());
        tagOptional.ifPresent(this.tagCallback::notifyCreation);
    }

    @Override
    public void close() throws Exception {
        this.tagCallback.close();
    }
}

