/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.metastore;

import java.time.Duration;
import java.util.List;
import org.apache.paimon.Snapshot;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.manifest.ManifestCommittable;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.metastore.MetastoreClient;
import org.apache.paimon.shade.guava30.com.google.common.cache.Cache;
import org.apache.paimon.shade.guava30.com.google.common.cache.CacheBuilder;
import org.apache.paimon.table.sink.CommitCallback;
import org.apache.paimon.table.sink.CommitMessage;

public class AddPartitionCommitCallback
implements CommitCallback {
    private final Cache<BinaryRow, Boolean> cache = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(30L)).maximumSize(300L).softValues().build();
    private final MetastoreClient client;

    public AddPartitionCommitCallback(MetastoreClient client) {
        this.client = client;
    }

    @Override
    public void call(List<ManifestEntry> committedEntries, Snapshot snapshot) {
        committedEntries.stream().filter(e -> FileKind.ADD.equals((Object)e.kind())).map(ManifestEntry::partition).distinct().forEach(this::addPartition);
    }

    @Override
    public void retry(ManifestCommittable committable) {
        committable.fileCommittables().stream().map(CommitMessage::partition).distinct().forEach(this::addPartition);
    }

    private void addPartition(BinaryRow partition) {
        try {
            boolean added = this.cache.get(partition, () -> false);
            if (added) {
                return;
            }
            this.client.addPartition(partition);
            this.cache.put(partition, true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws Exception {
        this.client.close();
    }
}

