/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.manifest;

import java.util.Arrays;
import java.util.Objects;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.index.IndexFileMeta;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.TinyIntType;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SerializationUtils;

@Public
public class IndexManifestEntry {
    public static final RowType SCHEMA = new RowType(false, Arrays.asList(new DataField(0, "_KIND", new TinyIntType(false)), new DataField(1, "_PARTITION", SerializationUtils.newBytesType(false)), new DataField(2, "_BUCKET", new IntType(false)), new DataField(3, "_INDEX_TYPE", SerializationUtils.newStringType(false)), new DataField(4, "_FILE_NAME", SerializationUtils.newStringType(false)), new DataField(5, "_FILE_SIZE", new BigIntType(false)), new DataField(6, "_ROW_COUNT", new BigIntType(false)), new DataField(7, "_DELETIONS_VECTORS_RANGES", new ArrayType(true, RowType.of(SerializationUtils.newStringType(false), new IntType(false), new IntType(false))))));
    private final FileKind kind;
    private final BinaryRow partition;
    private final int bucket;
    private final IndexFileMeta indexFile;

    public IndexManifestEntry(FileKind kind, BinaryRow partition, int bucket, IndexFileMeta indexFile) {
        this.kind = kind;
        this.partition = partition;
        this.bucket = bucket;
        this.indexFile = indexFile;
    }

    public IndexManifestEntry toDeleteEntry() {
        Preconditions.checkArgument(this.kind == FileKind.ADD);
        return new IndexManifestEntry(FileKind.DELETE, this.partition, this.bucket, this.indexFile);
    }

    public FileKind kind() {
        return this.kind;
    }

    public BinaryRow partition() {
        return this.partition;
    }

    public int bucket() {
        return this.bucket;
    }

    public IndexFileMeta indexFile() {
        return this.indexFile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexManifestEntry entry = (IndexManifestEntry)o;
        return this.bucket == entry.bucket && this.kind == entry.kind && Objects.equals(this.partition, entry.partition) && Objects.equals(this.indexFile, entry.indexFile);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.kind, this.partition, this.bucket, this.indexFile});
    }

    public String toString() {
        return "IndexManifestEntry{kind=" + (Object)((Object)this.kind) + ", partition=" + this.partition + ", bucket=" + this.bucket + ", indexFile=" + this.indexFile + '}';
    }
}

