/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io.cache;

import java.io.IOException;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.io.cache.CacheCallback;
import org.apache.paimon.io.cache.CacheKey;
import org.apache.paimon.io.cache.CacheReader;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.Cache;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.RemovalCause;

public class CacheManager {
    public static final int REFRESH_COUNT = 10;
    private final Cache<CacheKey, CacheValue> cache;
    private int fileReadCount;

    public CacheManager(MemorySize maxMemorySize) {
        this.cache = Caffeine.newBuilder().weigher(this::weigh).maximumWeight(maxMemorySize.getBytes()).removalListener(this::onRemoval).executor(Runnable::run).build();
        this.fileReadCount = 0;
    }

    @VisibleForTesting
    public Cache<CacheKey, ?> cache() {
        return this.cache;
    }

    public MemorySegment getPage(CacheKey key, CacheReader reader, CacheCallback callback) {
        CacheValue value = this.cache.getIfPresent(key);
        while (value == null || value.isClosed) {
            try {
                ++this.fileReadCount;
                value = new CacheValue(MemorySegment.wrap(reader.read(key)), callback);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.cache.put(key, value);
        }
        return value.segment;
    }

    public void invalidPage(CacheKey key) {
        this.cache.invalidate(key);
    }

    private int weigh(CacheKey cacheKey, CacheValue cacheValue) {
        return cacheValue.segment.size();
    }

    private void onRemoval(CacheKey key, CacheValue value, RemovalCause cause) {
        if (value != null) {
            value.isClosed = true;
            value.callback.onRemoval(key);
        }
    }

    public int fileReadCount() {
        return this.fileReadCount;
    }

    private static class CacheValue {
        private final MemorySegment segment;
        private final CacheCallback callback;
        private boolean isClosed = false;

        private CacheValue(MemorySegment segment, CacheCallback callback) {
            this.segment = segment;
            this.callback = callback;
        }
    }
}

