/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.paimon.io.DataFileMeta;

public class CompactIncrement {
    private final List<DataFileMeta> compactBefore;
    private final List<DataFileMeta> compactAfter;
    private final List<DataFileMeta> changelogFiles;

    public CompactIncrement(List<DataFileMeta> compactBefore, List<DataFileMeta> compactAfter, List<DataFileMeta> changelogFiles) {
        this.compactBefore = compactBefore;
        this.compactAfter = compactAfter;
        this.changelogFiles = changelogFiles;
    }

    public List<DataFileMeta> compactBefore() {
        return this.compactBefore;
    }

    public List<DataFileMeta> compactAfter() {
        return this.compactAfter;
    }

    public List<DataFileMeta> changelogFiles() {
        return this.changelogFiles;
    }

    public boolean isEmpty() {
        return this.compactBefore.isEmpty() && this.compactAfter.isEmpty() && this.changelogFiles.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompactIncrement that = (CompactIncrement)o;
        return Objects.equals(this.compactBefore, that.compactBefore) && Objects.equals(this.compactAfter, that.compactAfter) && Objects.equals(this.changelogFiles, that.changelogFiles);
    }

    public int hashCode() {
        return Objects.hash(this.compactBefore, this.compactAfter, this.changelogFiles);
    }

    public String toString() {
        return String.format("CompactIncrement {compactBefore = [\n%s\n], compactAfter = [\n%s\n], changelogFiles = [\n%s\n]}", this.compactBefore.stream().map(DataFileMeta::fileName).collect(Collectors.joining(",\n")), this.compactAfter.stream().map(DataFileMeta::fileName).collect(Collectors.joining(",\n")), this.changelogFiles.stream().map(DataFileMeta::fileName).collect(Collectors.joining(",\n")));
    }

    public static CompactIncrement emptyIncrement() {
        return new CompactIncrement(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }
}

