/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.iceberg.manifest;

import java.util.ArrayList;
import java.util.Objects;
import org.apache.paimon.iceberg.manifest.IcebergDataFileMeta;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;

public class IcebergManifestEntry {
    private final Status status;
    private final long snapshotId;
    private final long sequenceNumber;
    private final long fileSequenceNumber;
    private final IcebergDataFileMeta dataFile;

    public IcebergManifestEntry(Status status, long snapshotId, long sequenceNumber, long fileSequenceNumber, IcebergDataFileMeta dataFile) {
        this.status = status;
        this.snapshotId = snapshotId;
        this.sequenceNumber = sequenceNumber;
        this.fileSequenceNumber = fileSequenceNumber;
        this.dataFile = dataFile;
    }

    public Status status() {
        return this.status;
    }

    public boolean isLive() {
        return this.status == Status.ADDED || this.status == Status.EXISTING;
    }

    public long snapshotId() {
        return this.snapshotId;
    }

    public long sequenceNumber() {
        return this.sequenceNumber;
    }

    public long fileSequenceNumber() {
        return this.fileSequenceNumber;
    }

    public IcebergDataFileMeta file() {
        return this.dataFile;
    }

    public static RowType schema(RowType partitionType) {
        ArrayList<DataField> fields = new ArrayList<DataField>();
        fields.add(new DataField(0, "status", DataTypes.INT().notNull()));
        fields.add(new DataField(1, "snapshot_id", DataTypes.BIGINT()));
        fields.add(new DataField(3, "sequence_number", DataTypes.BIGINT()));
        fields.add(new DataField(4, "file_sequence_number", DataTypes.BIGINT()));
        fields.add(new DataField(2, "data_file", IcebergDataFileMeta.schema(partitionType).notNull()));
        return new RowType(fields);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IcebergManifestEntry that = (IcebergManifestEntry)o;
        return this.status == that.status && Objects.equals(this.dataFile, that.dataFile);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.dataFile});
    }

    public static enum Status {
        EXISTING(0),
        ADDED(1),
        DELETED(2);

        private final int id;

        private Status(int id) {
            this.id = id;
        }

        public int id() {
            return this.id;
        }

        public static Status fromId(int id) {
            switch (id) {
                case 0: {
                    return EXISTING;
                }
                case 1: {
                    return ADDED;
                }
                case 2: {
                    return DELETED;
                }
            }
            throw new IllegalArgumentException("Unknown manifest content: " + id);
        }
    }
}

