/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.table.hive.LegacyHiveClasses;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.catalog.AbstractCatalog;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.catalog.CatalogLockContext;
import org.apache.paimon.catalog.CatalogLockFactory;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.client.ClientPool;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.hive.HiveCatalogFactory;
import org.apache.paimon.hive.HiveCatalogLock;
import org.apache.paimon.hive.HiveCatalogLockContext;
import org.apache.paimon.hive.HiveCatalogLockFactory;
import org.apache.paimon.hive.HiveCatalogOptions;
import org.apache.paimon.hive.HiveFormatTableUtils;
import org.apache.paimon.hive.HiveMetastoreClient;
import org.apache.paimon.hive.HiveTypeUtils;
import org.apache.paimon.hive.LocationHelper;
import org.apache.paimon.hive.SerializableHiveConf;
import org.apache.paimon.hive.StorageLocationHelper;
import org.apache.paimon.hive.TBPropertiesLocationHelper;
import org.apache.paimon.hive.pool.CachedClientPool;
import org.apache.paimon.metastore.MetastoreClient;
import org.apache.paimon.operation.Lock;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.options.OptionsUtils;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaChange;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.FormatTable;
import org.apache.paimon.table.TableType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.StringUtils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveCatalog
extends AbstractCatalog {
    private static final Logger LOG = LoggerFactory.getLogger(HiveCatalog.class);
    public static final String TABLE_TYPE_PROP = "table_type";
    public static final String PAIMON_TABLE_TYPE_VALUE = "paimon";
    private static final String INPUT_FORMAT_CLASS_NAME = "org.apache.paimon.hive.mapred.PaimonInputFormat";
    private static final String OUTPUT_FORMAT_CLASS_NAME = "org.apache.paimon.hive.mapred.PaimonOutputFormat";
    private static final String SERDE_CLASS_NAME = "org.apache.paimon.hive.PaimonSerDe";
    private static final String STORAGE_HANDLER_CLASS_NAME = "org.apache.paimon.hive.PaimonStorageHandler";
    private static final String HIVE_PREFIX = "hive.";
    public static final String HIVE_SITE_FILE = "hive-site.xml";
    private final HiveConf hiveConf;
    private final String clientClassName;
    private final Options options;
    private final ClientPool<IMetaStoreClient, TException> clients;
    private final String warehouse;
    private final LocationHelper locationHelper;

    public HiveCatalog(FileIO fileIO, HiveConf hiveConf, String clientClassName, String warehouse) {
        this(fileIO, hiveConf, clientClassName, new Options(), warehouse);
    }

    public HiveCatalog(FileIO fileIO, HiveConf hiveConf, String clientClassName, Options options, String warehouse) {
        super(fileIO, options);
        this.hiveConf = hiveConf;
        this.clientClassName = clientClassName;
        this.options = options;
        this.warehouse = warehouse;
        boolean needLocationInProperties = hiveConf.getBoolean(HiveCatalogOptions.LOCATION_IN_PROPERTIES.key(), HiveCatalogOptions.LOCATION_IN_PROPERTIES.defaultValue().booleanValue());
        if (needLocationInProperties) {
            this.locationHelper = new TBPropertiesLocationHelper();
        } else {
            hiveConf.set(HiveConf.ConfVars.METASTOREWAREHOUSE.varname, warehouse);
            this.locationHelper = new StorageLocationHelper();
        }
        this.clients = new CachedClientPool((Configuration)hiveConf, options, clientClassName);
    }

    private boolean formatTableEnabled() {
        return this.options.get(HiveCatalogOptions.FORMAT_TABLE_ENABLED);
    }

    @Override
    public Optional<CatalogLockFactory> defaultLockFactory() {
        return Optional.of(new HiveCatalogLockFactory());
    }

    @Override
    public Optional<CatalogLockContext> lockContext() {
        return Optional.of(new HiveCatalogLockContext(new SerializableHiveConf(this.hiveConf), this.clientClassName, this.catalogOptions));
    }

    @Override
    public Optional<MetastoreClient.Factory> metastoreClientFactory(Identifier identifier) {
        Identifier tableIdentifier = new Identifier(identifier.getDatabaseName(), identifier.getTableName());
        try {
            return Optional.of(new HiveMetastoreClient.Factory(tableIdentifier, this.getDataTableSchema(tableIdentifier), this.hiveConf, this.clientClassName, this.options));
        }
        catch (Catalog.TableNotExistException e) {
            throw new RuntimeException("Table " + identifier + " does not exist. This is unexpected.", e);
        }
    }

    @Override
    public Path getTableLocation(Identifier identifier) {
        try {
            String databaseName = identifier.getDatabaseName();
            String tableName = identifier.getTableName();
            Optional tablePath = this.clients.run(client -> {
                if (client.tableExists(databaseName, tableName)) {
                    String location = this.locationHelper.getTableLocation(client.getTable(databaseName, tableName));
                    if (location != null) {
                        return Optional.of(new Path(location));
                    }
                } else {
                    String dbLocation = this.locationHelper.getDatabaseLocation(client.getDatabase(databaseName));
                    if (dbLocation != null) {
                        return Optional.of(new Path(dbLocation, tableName));
                    }
                }
                return Optional.empty();
            });
            return tablePath.orElse(super.getTableLocation(identifier));
        }
        catch (TException e) {
            throw new RuntimeException("Can not get table " + identifier + " from metastore.", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to getDataTableLocation " + identifier, e);
        }
    }

    @Override
    public List<String> listDatabases() {
        try {
            return this.clients.run(IMetaStoreClient::getAllDatabases);
        }
        catch (TException e) {
            throw new RuntimeException("Failed to list all databases", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to listDatabases", e);
        }
    }

    @Override
    protected void createDatabaseImpl(String name, Map<String, String> properties) {
        try {
            Database database = this.convertToHiveDatabase(name, properties);
            Path databasePath = database.getLocationUri() == null ? this.newDatabasePath(name) : new Path(database.getLocationUri());
            this.locationHelper.createPathIfRequired(databasePath, this.fileIO);
            this.locationHelper.specifyDatabaseLocation(databasePath, database);
            this.clients.execute(client -> client.createDatabase(database));
        }
        catch (IOException | TException e) {
            throw new RuntimeException("Failed to create database " + name, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to createDatabase " + name, e);
        }
    }

    private Database convertToHiveDatabase(String name, Map<String, String> properties) {
        Database database = new Database();
        database.setName(name);
        HashMap parameter = new HashMap();
        properties.forEach((key, value) -> {
            if (key.equals("comment")) {
                database.setDescription(value);
            } else if (key.equals("location")) {
                database.setLocationUri(value);
            } else if (value != null) {
                parameter.put(key, value);
            }
        });
        database.setParameters(parameter);
        return database;
    }

    @Override
    public Map<String, String> loadDatabasePropertiesImpl(String name) throws Catalog.DatabaseNotExistException {
        try {
            return this.convertToProperties(this.clients.run(client -> client.getDatabase(name)));
        }
        catch (NoSuchObjectException e) {
            throw new Catalog.DatabaseNotExistException(name);
        }
        catch (TException e) {
            throw new RuntimeException(String.format("Failed to get database %s properties", name), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to loadDatabaseProperties " + name, e);
        }
    }

    private Map<String, String> convertToProperties(Database database) {
        HashMap<String, String> properties = new HashMap<String, String>(database.getParameters());
        if (database.getLocationUri() != null) {
            properties.put("location", database.getLocationUri());
        }
        if (database.getDescription() != null) {
            properties.put("comment", database.getDescription());
        }
        return properties;
    }

    @Override
    public void dropPartition(Identifier identifier, Map<String, String> partitionSpec) throws Catalog.TableNotExistException {
        TableSchema tableSchema = this.getDataTableSchema(identifier);
        if (!tableSchema.partitionKeys().isEmpty() && new CoreOptions(tableSchema.options()).partitionedTableInMetastore() && !this.partitionExistsInOtherBranches(identifier, partitionSpec)) {
            try {
                HiveMetastoreClient metastoreClient = new HiveMetastoreClient(new Identifier(identifier.getDatabaseName(), identifier.getTableName()), tableSchema, this.clients);
                metastoreClient.deletePartition(new LinkedHashMap<String, String>(partitionSpec));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        super.dropPartition(identifier, partitionSpec);
    }

    private boolean partitionExistsInOtherBranches(Identifier identifier, Map<String, String> partitionSpec) throws Catalog.TableNotExistException {
        FileStoreTable mainTable = (FileStoreTable)this.getTable(new Identifier(identifier.getDatabaseName(), identifier.getTableName()));
        ArrayList<String> branchNames = new ArrayList<String>(mainTable.branchManager().branches());
        branchNames.add("main");
        for (String branchName : branchNames) {
            FileStoreTable table;
            Optional<TableSchema> branchSchema;
            if (branchName.equals(identifier.getBranchNameOrDefault()) || !(branchSchema = this.tableSchemaInFileSystem(mainTable.location(), branchName)).isPresent() || (table = mainTable.switchToBranch(branchName)).newScan().withPartitionFilter(partitionSpec).listPartitions().isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void dropDatabaseImpl(String name) {
        try {
            Database database = this.clients.run(client -> client.getDatabase(name));
            String location = this.locationHelper.getDatabaseLocation(database);
            this.locationHelper.dropPathIfRequired(new Path(location), this.fileIO);
            this.clients.execute(client -> client.dropDatabase(name, true, false, true));
        }
        catch (IOException | TException e) {
            throw new RuntimeException("Failed to drop database " + name, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to dropDatabase " + name, e);
        }
    }

    @Override
    protected List<String> listTablesImpl(String databaseName) {
        try {
            return this.clients.run(client -> client.getAllTables(databaseName).stream().filter(tableName -> {
                Identifier identifier = new Identifier(databaseName, (String)tableName);
                return this.tableExists(identifier);
            }).collect(Collectors.toList()));
        }
        catch (TException e) {
            throw new RuntimeException("Failed to list all tables in database " + databaseName, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to listTables " + databaseName, e);
        }
    }

    @Override
    public boolean tableExists(Identifier identifier) {
        boolean isDataTable;
        Table table;
        if (HiveCatalog.isSystemTable(identifier)) {
            return super.tableExists(identifier);
        }
        try {
            table = this.clients.run(client -> client.getTable(identifier.getDatabaseName(), identifier.getTableName()));
        }
        catch (NoSuchObjectException e) {
            return false;
        }
        catch (TException e) {
            throw new RuntimeException("Cannot determine if table " + identifier.getFullName() + " is a paimon table.", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to tableExists " + identifier.getFullName(), e);
        }
        boolean bl = isDataTable = HiveCatalog.isPaimonTable(table) && this.tableSchemaInFileSystem(this.getTableLocation(identifier), identifier.getBranchNameOrDefault()).isPresent();
        if (isDataTable) {
            return true;
        }
        if (this.formatTableEnabled()) {
            try {
                HiveFormatTableUtils.convertToFormatTable(table);
                return true;
            }
            catch (UnsupportedOperationException e) {
                return false;
            }
        }
        return false;
    }

    private static boolean isPaimonTable(Table table) {
        boolean isPaimonTable = INPUT_FORMAT_CLASS_NAME.equals(table.getSd().getInputFormat()) && OUTPUT_FORMAT_CLASS_NAME.equals(table.getSd().getOutputFormat());
        return isPaimonTable || LegacyHiveClasses.isPaimonTable(table);
    }

    @Override
    public TableSchema getDataTableSchema(Identifier identifier) throws Catalog.TableNotExistException {
        if (!this.tableExists(identifier)) {
            throw new Catalog.TableNotExistException(identifier);
        }
        return this.tableSchemaInFileSystem(this.getTableLocation(identifier), identifier.getBranchNameOrDefault()).orElseThrow(() -> new Catalog.TableNotExistException(identifier));
    }

    @Override
    public FormatTable getFormatTable(Identifier identifier) throws Catalog.TableNotExistException {
        Table table;
        if (!this.formatTableEnabled()) {
            throw new Catalog.TableNotExistException(identifier);
        }
        try {
            table = this.clients.run(client -> client.getTable(identifier.getDatabaseName(), identifier.getTableName()));
        }
        catch (NoSuchObjectException e) {
            throw new Catalog.TableNotExistException(identifier);
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        try {
            return HiveFormatTableUtils.convertToFormatTable(table);
        }
        catch (UnsupportedOperationException e) {
            throw new Catalog.TableNotExistException(identifier);
        }
    }

    private boolean usingExternalTable() {
        TableType tableType = OptionsUtils.convertToEnum(this.hiveConf.get(CatalogOptions.TABLE_TYPE.key(), TableType.MANAGED.toString()), TableType.class);
        return TableType.EXTERNAL.equals(tableType);
    }

    @Override
    protected void dropTableImpl(Identifier identifier) {
        try {
            this.clients.execute(client -> client.dropTable(identifier.getDatabaseName(), identifier.getTableName(), true, false, true));
            if (this.usingExternalTable()) {
                return;
            }
            Path path = this.getTableLocation(identifier);
            try {
                if (this.fileIO.exists(path)) {
                    this.fileIO.deleteDirectoryQuietly(path);
                }
            }
            catch (Exception ee) {
                LOG.error("Delete directory[{}] fail for table {}", new Object[]{path, identifier, ee});
            }
        }
        catch (TException e) {
            throw new RuntimeException("Failed to drop table " + identifier.getFullName(), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to dropTable " + identifier.getFullName(), e);
        }
    }

    @Override
    protected void createTableImpl(Identifier identifier, Schema schema) {
        TableSchema tableSchema;
        try {
            tableSchema = this.schemaManager(identifier).createTable(schema, this.usingExternalTable());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to commit changes of table " + identifier.getFullName() + " to underlying files.", e);
        }
        try {
            this.clients.execute(client -> client.createTable(this.createHiveTable(identifier, tableSchema)));
        }
        catch (Exception e) {
            Path path = this.getTableLocation(identifier);
            try {
                this.fileIO.deleteDirectoryQuietly(path);
            }
            catch (Exception ee) {
                LOG.error("Delete directory[{}] fail for table {}", new Object[]{path, identifier, ee});
            }
            throw new RuntimeException("Failed to create table " + identifier.getFullName(), e);
        }
    }

    private Table createHiveTable(Identifier identifier, TableSchema tableSchema) {
        Map<String, String> tblProperties;
        if (this.syncAllProperties()) {
            tblProperties = new HashMap<String, String>(tableSchema.options());
            tblProperties.putAll(this.convertToPropertiesTableKey(tableSchema));
        } else {
            tblProperties = OptionsUtils.convertToPropertiesPrefixKey(tableSchema.options(), HIVE_PREFIX);
        }
        Table table = this.newHmsTable(identifier, tblProperties);
        this.updateHmsTable(table, identifier, tableSchema);
        return table;
    }

    @Override
    protected void renameTableImpl(Identifier fromTable, Identifier toTable) {
        block5: {
            try {
                String fromDB = fromTable.getDatabaseName();
                String fromTableName = fromTable.getTableName();
                Table table = this.clients.run(client -> client.getTable(fromDB, fromTableName));
                table.setDbName(toTable.getDatabaseName());
                table.setTableName(toTable.getTableName());
                this.clients.execute(client -> client.alter_table(fromDB, fromTableName, table));
                Path fromPath = this.getTableLocation(fromTable);
                if (new SchemaManager(this.fileIO, fromPath).listAllIds().isEmpty()) break block5;
                Path toPath = this.getTableLocation(toTable);
                try {
                    this.fileIO.rename(fromPath, toPath);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to rename changes of table " + toTable.getFullName() + " to underlying files.", e);
                }
                this.locationHelper.specifyTableLocation(table, toPath.toString());
                this.clients.execute(client -> client.alter_table(toTable.getDatabaseName(), toTable.getTableName(), table));
            }
            catch (TException e) {
                throw new RuntimeException("Failed to rename table " + fromTable.getFullName(), e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Interrupted in call to renameTable", e);
            }
        }
    }

    @Override
    protected void alterTableImpl(Identifier identifier, List<SchemaChange> changes) throws Catalog.TableNotExistException, Catalog.ColumnAlreadyExistException, Catalog.ColumnNotExistException {
        SchemaManager schemaManager = this.schemaManager(identifier);
        TableSchema schema = schemaManager.commitChanges(changes);
        if (!"main".equals(identifier.getBranchNameOrDefault())) {
            return;
        }
        try {
            Table table = this.clients.run(client -> client.getTable(identifier.getDatabaseName(), identifier.getTableName()));
            this.alterTableToHms(table, identifier, schema);
        }
        catch (Exception te) {
            schemaManager.deleteSchema(schema.id());
            throw new RuntimeException(te);
        }
    }

    private void alterTableToHms(Table table, Identifier identifier, TableSchema newSchema) throws TException, InterruptedException {
        this.updateHmsTablePars(table, newSchema);
        this.updateHmsTable(table, identifier, newSchema);
        this.clients.execute(client -> client.alter_table(identifier.getDatabaseName(), identifier.getTableName(), table, true));
    }

    @Override
    public boolean allowUpperCase() {
        return this.catalogOptions.getOptional(CatalogOptions.ALLOW_UPPER_CASE).orElse(false);
    }

    public boolean syncAllProperties() {
        return this.catalogOptions.get(CatalogOptions.SYNC_ALL_PROPERTIES);
    }

    @Override
    public void repairCatalog() {
        List<String> databases = null;
        try {
            databases = this.listDatabasesInFileSystem(new Path(this.warehouse));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        for (String database : databases) {
            this.repairDatabase(database);
        }
    }

    @Override
    public void repairDatabase(String databaseName) {
        List<String> tables;
        this.checkNotSystemDatabase(databaseName);
        if (!this.databaseExists(databaseName)) {
            this.createDatabaseImpl(databaseName, Collections.emptyMap());
        }
        try {
            Database database = this.clients.run(client -> client.getDatabase(databaseName));
            tables = this.listTablesInFileSystem(new Path(this.locationHelper.getDatabaseLocation(database)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (String table : tables) {
            try {
                this.repairTable(Identifier.create(databaseName, table));
            }
            catch (Catalog.TableNotExistException tableNotExistException) {}
        }
    }

    @Override
    public void repairTable(Identifier identifier) throws Catalog.TableNotExistException {
        HiveCatalog.checkNotBranch(identifier, "repairTable");
        HiveCatalog.checkNotSystemTable(identifier, "repairTable");
        this.validateIdentifierNameCaseInsensitive(identifier);
        TableSchema tableSchema = this.tableSchemaInFileSystem(this.getTableLocation(identifier), identifier.getBranchNameOrDefault()).orElseThrow(() -> new Catalog.TableNotExistException(identifier));
        Table newTable = this.createHiveTable(identifier, tableSchema);
        try {
            try {
                Table table = this.clients.run(client -> client.getTable(identifier.getDatabaseName(), identifier.getTableName()));
                Preconditions.checkArgument(HiveCatalog.isPaimonTable(table), "Table %s is not a paimon table in hive metastore.", identifier.getFullName());
                if (!newTable.getSd().getCols().equals(table.getSd().getCols()) || !newTable.getParameters().equals(table.getParameters())) {
                    this.alterTableToHms(table, identifier, tableSchema);
                }
            }
            catch (NoSuchObjectException e) {
                this.clients.execute(client -> client.createTable(newTable));
            }
            if (!tableSchema.partitionKeys().isEmpty() && !newTable.getPartitionKeys().isEmpty()) {
                HiveMetastoreClient metastoreClient = new HiveMetastoreClient(identifier, tableSchema, this.clients);
                List<BinaryRow> partitions = this.getTable(identifier).newReadBuilder().newScan().listPartitions();
                for (BinaryRow partition : partitions) {
                    metastoreClient.addPartition(partition);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public String warehouse() {
        return this.warehouse;
    }

    private Table newHmsTable(Identifier identifier, Map<String, String> tableParameters) {
        long currentTimeMillis = System.currentTimeMillis();
        TableType tableType = OptionsUtils.convertToEnum(this.hiveConf.get(CatalogOptions.TABLE_TYPE.key(), TableType.MANAGED.toString()), TableType.class);
        Table table = new Table(identifier.getTableName(), identifier.getDatabaseName(), System.getProperty("user.name"), (int)(currentTimeMillis / 1000L), (int)(currentTimeMillis / 1000L), Integer.MAX_VALUE, null, Collections.emptyList(), tableParameters, null, null, tableType.toString().toUpperCase(Locale.ROOT) + "_TABLE");
        table.getParameters().put(TABLE_TYPE_PROP, PAIMON_TABLE_TYPE_VALUE.toUpperCase());
        table.getParameters().put("storage_handler", STORAGE_HANDLER_CLASS_NAME);
        if (TableType.EXTERNAL.equals(tableType)) {
            table.getParameters().put("EXTERNAL", "TRUE");
        }
        return table;
    }

    private void updateHmsTable(Table table, Identifier identifier, TableSchema schema) {
        StorageDescriptor sd = table.getSd() != null ? table.getSd() : new StorageDescriptor();
        sd.setInputFormat(INPUT_FORMAT_CLASS_NAME);
        sd.setOutputFormat(OUTPUT_FORMAT_CLASS_NAME);
        SerDeInfo serDeInfo = sd.getSerdeInfo() != null ? sd.getSerdeInfo() : new SerDeInfo();
        serDeInfo.setParameters(new HashMap());
        serDeInfo.setSerializationLib(SERDE_CLASS_NAME);
        sd.setSerdeInfo(serDeInfo);
        CoreOptions options = new CoreOptions(schema.options());
        if (options.partitionedTableInMetastore() && !schema.partitionKeys().isEmpty()) {
            Map fieldMap = schema.fields().stream().collect(Collectors.toMap(DataField::name, Function.identity()));
            ArrayList<FieldSchema> partitionFields = new ArrayList<FieldSchema>();
            for (String partitionKey : schema.partitionKeys()) {
                partitionFields.add(this.convertToFieldSchema((DataField)fieldMap.get(partitionKey)));
            }
            table.setPartitionKeys(partitionFields);
            HashSet<String> partitionKeys = new HashSet<String>(schema.partitionKeys());
            ArrayList<FieldSchema> normalFields = new ArrayList<FieldSchema>();
            for (DataField field : schema.fields()) {
                if (partitionKeys.contains(field.name())) continue;
                normalFields.add(this.convertToFieldSchema(field));
            }
            sd.setCols(normalFields);
        } else {
            if (options.tagToPartitionField() != null) {
                Preconditions.checkArgument(schema.partitionKeys().isEmpty(), "Partition table can not use timeTravelToPartitionField.");
                table.setPartitionKeys(Collections.singletonList(this.convertToFieldSchema(new DataField(0, options.tagToPartitionField(), DataTypes.STRING()))));
            }
            sd.setCols(schema.fields().stream().map(this::convertToFieldSchema).collect(Collectors.toList()));
        }
        table.setSd(sd);
        if (schema.comment() != null) {
            table.getParameters().put("comment", schema.comment());
        }
        this.locationHelper.specifyTableLocation(table, this.getTableLocation(identifier).toString());
    }

    private void updateHmsTablePars(Table table, TableSchema schema) {
        if (this.syncAllProperties()) {
            table.getParameters().putAll(schema.options());
            table.getParameters().putAll(this.convertToPropertiesTableKey(schema));
        } else {
            table.getParameters().putAll(OptionsUtils.convertToPropertiesPrefixKey(schema.options(), HIVE_PREFIX));
        }
    }

    private Map<String, String> convertToPropertiesTableKey(TableSchema tableSchema) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (!tableSchema.primaryKeys().isEmpty()) {
            properties.put(CoreOptions.PRIMARY_KEY.key(), String.join((CharSequence)",", tableSchema.primaryKeys()));
        }
        if (!tableSchema.partitionKeys().isEmpty()) {
            properties.put(CoreOptions.PARTITION.key(), String.join((CharSequence)",", tableSchema.partitionKeys()));
        }
        if (!tableSchema.bucketKeys().isEmpty()) {
            properties.put(CoreOptions.BUCKET_KEY.key(), String.join((CharSequence)",", tableSchema.bucketKeys()));
        }
        return properties;
    }

    @VisibleForTesting
    public IMetaStoreClient getHmsClient() {
        try {
            return this.clients.run(client -> client);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to close hms client:", e);
        }
    }

    private FieldSchema convertToFieldSchema(DataField dataField) {
        return new FieldSchema(dataField.name(), HiveTypeUtils.toTypeInfo(dataField.type()).getTypeName(), dataField.description());
    }

    private SchemaManager schemaManager(Identifier identifier) {
        return new SchemaManager(this.fileIO, this.getTableLocation(identifier), identifier.getBranchNameOrDefault()).withLock(this.lock(identifier));
    }

    private Lock lock(Identifier identifier) {
        if (!this.lockEnabled()) {
            return new Lock.EmptyLock();
        }
        HiveCatalogLock lock = new HiveCatalogLock(this.clients, HiveCatalogLock.checkMaxSleep(this.hiveConf), HiveCatalogLock.acquireTimeout(this.hiveConf));
        return Lock.fromCatalog(lock, identifier);
    }

    public static HiveConf createHiveConf(@Nullable String hiveConfDir, @Nullable String hadoopConfDir, Configuration defaultHadoopConf) {
        if (StringUtils.isNullOrWhitespaceOnly(hiveConfDir)) {
            hiveConfDir = HiveCatalog.possibleHiveConfPath();
        }
        Configuration hadoopConf = defaultHadoopConf;
        if (!StringUtils.isNullOrWhitespaceOnly(hadoopConfDir) && (hadoopConf = HiveCatalog.getHadoopConfiguration(hadoopConfDir)) == null) {
            String possiableUsedConfFiles = "core-site.xml | hdfs-site.xml | yarn-site.xml | mapred-site.xml";
            throw new RuntimeException("Failed to load the hadoop conf from specified path:" + hadoopConfDir, new FileNotFoundException("Please check the path none of the conf files (" + possiableUsedConfFiles + ") exist in the folder."));
        }
        LOG.info("Setting hive conf dir as {}", (Object)hiveConfDir);
        if (hiveConfDir != null) {
            HiveConf.setHiveSiteLocation(null);
            HiveConf.setLoadMetastoreConfig((boolean)false);
            HiveConf.setLoadHiveServer2Config((boolean)false);
            HiveConf hiveConf = new HiveConf(hadoopConf, HiveConf.class);
            org.apache.hadoop.fs.Path hiveSite = new org.apache.hadoop.fs.Path(hiveConfDir, HIVE_SITE_FILE);
            if (!hiveSite.toUri().isAbsolute()) {
                hiveSite = new org.apache.hadoop.fs.Path(new File(hiveSite.toString()).toURI());
            }
            try (FSDataInputStream inputStream = hiveSite.getFileSystem(hadoopConf).open(hiveSite);){
                hiveConf.addResource((InputStream)inputStream, hiveSite.toString());
                hiveConf.getVar(HiveConf.ConfVars.METASTOREURIS);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load hive-site.xml from specified path:" + hiveSite, e);
            }
            hiveConf.addResource(hiveSite);
            return hiveConf;
        }
        HiveConf hiveConf = new HiveConf(hadoopConf, HiveConf.class);
        URL hiveSite = Thread.currentThread().getContextClassLoader().getResource(HIVE_SITE_FILE);
        if (hiveSite != null) {
            LOG.info("Found {} in classpath: {}", (Object)HIVE_SITE_FILE, (Object)hiveSite);
            hiveConf.addResource(hiveSite);
        }
        return hiveConf;
    }

    public static Catalog createHiveCatalog(CatalogContext context) {
        FileIO fileIO;
        Path warehouse;
        HiveConf hiveConf = HiveCatalog.createHiveConf(context);
        Options options = context.options();
        String warehouseStr = options.get(CatalogOptions.WAREHOUSE);
        if (warehouseStr == null) {
            warehouseStr = hiveConf.get(HiveConf.ConfVars.METASTOREWAREHOUSE.varname, HiveConf.ConfVars.METASTOREWAREHOUSE.defaultStrVal);
        }
        Path uri = (warehouse = new Path(warehouseStr)).toUri().getScheme() == null ? new Path(FileSystem.getDefaultUri((Configuration)hiveConf)) : warehouse;
        try {
            fileIO = FileIO.get(uri, context);
            fileIO.checkOrMkdirs(warehouse);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new HiveCatalog(fileIO, hiveConf, options.get(HiveCatalogFactory.METASTORE_CLIENT_CLASS), options, warehouse.toUri().toString());
    }

    public static HiveConf createHiveConf(CatalogContext context) {
        String uri = context.options().get(CatalogOptions.URI);
        String hiveConfDir = context.options().get(HiveCatalogOptions.HIVE_CONF_DIR);
        String hadoopConfDir = context.options().get(HiveCatalogOptions.HADOOP_CONF_DIR);
        HiveConf hiveConf = HiveCatalog.createHiveConf(hiveConfDir, hadoopConfDir, context.hadoopConf());
        context.options().toMap().forEach((arg_0, arg_1) -> ((HiveConf)hiveConf).set(arg_0, arg_1));
        if (uri != null) {
            hiveConf.set(HiveConf.ConfVars.METASTOREURIS.varname, uri);
        }
        if (hiveConf.get(HiveConf.ConfVars.METASTOREURIS.varname) == null) {
            LOG.error("Can't find hive metastore uri to connect:  either set " + CatalogOptions.URI.key() + " for paimon " + "hive" + " catalog or set hive.metastore.uris in hive-site.xml or hadoop configurations. Will use empty metastore uris, which means we may use a embedded metastore. The may cause unpredictable consensus problem.");
        }
        return hiveConf;
    }

    public static Configuration getHadoopConfiguration(String hadoopConfDir) {
        if (new File(hadoopConfDir).exists()) {
            File mapredSite;
            File yarnSite;
            File hdfsSite;
            ArrayList<File> possiableConfFiles = new ArrayList<File>();
            File coreSite = new File(hadoopConfDir, "core-site.xml");
            if (coreSite.exists()) {
                possiableConfFiles.add(coreSite);
            }
            if ((hdfsSite = new File(hadoopConfDir, "hdfs-site.xml")).exists()) {
                possiableConfFiles.add(hdfsSite);
            }
            if ((yarnSite = new File(hadoopConfDir, "yarn-site.xml")).exists()) {
                possiableConfFiles.add(yarnSite);
            }
            if ((mapredSite = new File(hadoopConfDir, "mapred-site.xml")).exists()) {
                possiableConfFiles.add(mapredSite);
            }
            if (possiableConfFiles.isEmpty()) {
                return null;
            }
            Configuration hadoopConfiguration = new Configuration();
            for (File confFile : possiableConfFiles) {
                hadoopConfiguration.addResource(new org.apache.hadoop.fs.Path(confFile.getAbsolutePath()));
            }
            return hadoopConfiguration;
        }
        return null;
    }

    public static String possibleHiveConfPath() {
        return System.getenv("HIVE_CONF_DIR");
    }
}

