/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet.writer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.format.parquet.ParquetSchemaConverter;
import org.apache.paimon.format.parquet.reader.TimestampColumnReader;
import org.apache.paimon.shade.org.apache.parquet.io.api.Binary;
import org.apache.paimon.shade.org.apache.parquet.io.api.RecordConsumer;
import org.apache.paimon.shade.org.apache.parquet.schema.GroupType;
import org.apache.paimon.shade.org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.paimon.shade.org.apache.parquet.schema.Type;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.LocalZonedTimestampType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.MultisetType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.TimestampType;
import org.apache.paimon.utils.Preconditions;

public class ParquetRowDataWriter {
    private final RowWriter rowWriter;
    private final RecordConsumer recordConsumer;

    public ParquetRowDataWriter(RecordConsumer recordConsumer, RowType rowType, GroupType schema) {
        this.recordConsumer = recordConsumer;
        this.rowWriter = new RowWriter(rowType, schema);
    }

    public void write(InternalRow record) {
        this.recordConsumer.startMessage();
        this.rowWriter.write(record);
        this.recordConsumer.endMessage();
    }

    private FieldWriter createWriter(DataType t, Type type) {
        if (type.isPrimitive()) {
            switch (t.getTypeRoot()) {
                case CHAR: 
                case VARCHAR: {
                    return new StringWriter();
                }
                case BOOLEAN: {
                    return new BooleanWriter();
                }
                case BINARY: 
                case VARBINARY: {
                    return new BinaryWriter();
                }
                case DECIMAL: {
                    DecimalType decimalType = (DecimalType)t;
                    return this.createDecimalWriter(decimalType.getPrecision(), decimalType.getScale());
                }
                case TINYINT: {
                    return new ByteWriter();
                }
                case SMALLINT: {
                    return new ShortWriter();
                }
                case DATE: 
                case TIME_WITHOUT_TIME_ZONE: 
                case INTEGER: {
                    return new IntWriter();
                }
                case BIGINT: {
                    return new LongWriter();
                }
                case FLOAT: {
                    return new FloatWriter();
                }
                case DOUBLE: {
                    return new DoubleWriter();
                }
                case TIMESTAMP_WITHOUT_TIME_ZONE: {
                    TimestampType timestampType = (TimestampType)t;
                    return this.createTimestampWriter(timestampType.getPrecision());
                }
                case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                    LocalZonedTimestampType localZonedTimestampType = (LocalZonedTimestampType)t;
                    return this.createTimestampWriter(localZonedTimestampType.getPrecision());
                }
            }
            throw new UnsupportedOperationException("Unsupported type: " + type);
        }
        GroupType groupType = type.asGroupType();
        LogicalTypeAnnotation annotation = type.getLogicalTypeAnnotation();
        if (t instanceof ArrayType && annotation instanceof LogicalTypeAnnotation.ListLogicalTypeAnnotation) {
            return new ArrayWriter(((ArrayType)t).getElementType(), groupType);
        }
        if (t instanceof MapType && annotation instanceof LogicalTypeAnnotation.MapLogicalTypeAnnotation) {
            return new MapWriter(((MapType)t).getKeyType(), ((MapType)t).getValueType(), groupType);
        }
        if (t instanceof MultisetType && annotation instanceof LogicalTypeAnnotation.MapLogicalTypeAnnotation) {
            return new MapWriter(((MultisetType)t).getElementType(), new IntType(false), groupType);
        }
        if (t instanceof RowType && type instanceof GroupType) {
            return new RowWriter((RowType)t, groupType);
        }
        throw new UnsupportedOperationException("Unsupported type: " + type);
    }

    private FieldWriter createTimestampWriter(int precision) {
        if (precision <= 3) {
            return new TimestampMillsWriter(precision);
        }
        if (precision > 6) {
            return new TimestampInt96Writer(precision);
        }
        return new TimestampMicrosWriter(precision);
    }

    private Binary timestampToInt96(Timestamp timestamp) {
        long mills = timestamp.getMillisecond();
        int julianDay = (int)(mills / TimestampColumnReader.MILLIS_IN_DAY + 2440588L);
        long nanosOfDay = mills % TimestampColumnReader.MILLIS_IN_DAY * TimestampColumnReader.NANOS_PER_MILLISECOND + (long)timestamp.getNanoOfMillisecond();
        ByteBuffer buf = ByteBuffer.allocate(12);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putLong(nanosOfDay);
        buf.putInt(julianDay);
        buf.flip();
        return Binary.fromConstantByteBuffer(buf);
    }

    private FieldWriter createDecimalWriter(final int precision, final int scale) {
        Preconditions.checkArgument(precision <= 38, "Decimal precision %s exceeds max precision %s", precision, 38);
        if (ParquetSchemaConverter.is32BitDecimal(precision)) {
            class Int32Writer
            implements FieldWriter {
                Int32Writer() {
                }

                @Override
                public void write(InternalArray arrayData, int ordinal) {
                    long unscaledLong = arrayData.getDecimal(ordinal, precision, scale).toUnscaledLong();
                    this.addRecord(unscaledLong);
                }

                @Override
                public void write(InternalRow row, int ordinal) {
                    long unscaledLong = row.getDecimal(ordinal, precision, scale).toUnscaledLong();
                    this.addRecord(unscaledLong);
                }

                private void addRecord(long unscaledLong) {
                    ParquetRowDataWriter.this.recordConsumer.addInteger((int)unscaledLong);
                }
            }
            return new Int32Writer();
        }
        if (ParquetSchemaConverter.is64BitDecimal(precision)) {
            class Int64Writer
            implements FieldWriter {
                Int64Writer() {
                }

                @Override
                public void write(InternalArray arrayData, int ordinal) {
                    long unscaledLong = arrayData.getDecimal(ordinal, precision, scale).toUnscaledLong();
                    this.addRecord(unscaledLong);
                }

                @Override
                public void write(InternalRow row, int ordinal) {
                    long unscaledLong = row.getDecimal(ordinal, precision, scale).toUnscaledLong();
                    this.addRecord(unscaledLong);
                }

                private void addRecord(long unscaledLong) {
                    ParquetRowDataWriter.this.recordConsumer.addLong(unscaledLong);
                }
            }
            return new Int64Writer();
        }
        class UnscaledBytesWriter
        implements FieldWriter {
            private final int numBytes;
            private final byte[] decimalBuffer;

            UnscaledBytesWriter() {
                this.numBytes = ParquetSchemaConverter.computeMinBytesForDecimalPrecision(precision);
                this.decimalBuffer = new byte[this.numBytes];
            }

            @Override
            public void write(InternalArray arrayData, int ordinal) {
                byte[] bytes = arrayData.getDecimal(ordinal, precision, scale).toUnscaledBytes();
                this.addRecord(bytes);
            }

            @Override
            public void write(InternalRow row, int ordinal) {
                byte[] bytes = row.getDecimal(ordinal, precision, scale).toUnscaledBytes();
                this.addRecord(bytes);
            }

            private void addRecord(byte[] bytes) {
                byte[] writtenBytes;
                if (bytes.length == this.numBytes) {
                    writtenBytes = bytes;
                } else {
                    byte signByte = bytes[0] < 0 ? (byte)-1 : 0;
                    Arrays.fill(this.decimalBuffer, 0, this.numBytes - bytes.length, signByte);
                    System.arraycopy(bytes, 0, this.decimalBuffer, this.numBytes - bytes.length, bytes.length);
                    writtenBytes = this.decimalBuffer;
                }
                ParquetRowDataWriter.this.recordConsumer.addBinary(Binary.fromReusedByteArray(writtenBytes, 0, this.numBytes));
            }
        }
        return new UnscaledBytesWriter();
    }

    private class RowWriter
    implements FieldWriter {
        private final FieldWriter[] fieldWriters;
        private final String[] fieldNames;

        public RowWriter(RowType rowType, GroupType groupType) {
            this.fieldNames = rowType.getFieldNames().toArray(new String[0]);
            List<DataType> fieldTypes = rowType.getFieldTypes();
            this.fieldWriters = new FieldWriter[rowType.getFieldCount()];
            for (int i = 0; i < this.fieldWriters.length; ++i) {
                this.fieldWriters[i] = ParquetRowDataWriter.this.createWriter(fieldTypes.get(i), groupType.getType(i));
            }
        }

        public void write(InternalRow row) {
            for (int i = 0; i < this.fieldWriters.length; ++i) {
                if (row.isNullAt(i)) continue;
                String fieldName = this.fieldNames[i];
                FieldWriter writer = this.fieldWriters[i];
                ParquetRowDataWriter.this.recordConsumer.startField(fieldName, i);
                writer.write(row, i);
                ParquetRowDataWriter.this.recordConsumer.endField(fieldName, i);
            }
        }

        @Override
        public void write(InternalRow row, int ordinal) {
            ParquetRowDataWriter.this.recordConsumer.startGroup();
            InternalRow rowData = row.getRow(ordinal, this.fieldWriters.length);
            this.write(rowData);
            ParquetRowDataWriter.this.recordConsumer.endGroup();
        }

        @Override
        public void write(InternalArray arrayData, int ordinal) {
            ParquetRowDataWriter.this.recordConsumer.startGroup();
            InternalRow rowData = arrayData.getRow(ordinal, this.fieldWriters.length);
            this.write(rowData);
            ParquetRowDataWriter.this.recordConsumer.endGroup();
        }
    }

    private class ArrayWriter
    implements FieldWriter {
        private final String elementName;
        private final FieldWriter elementWriter;
        private final String repeatedGroupName;

        private ArrayWriter(DataType t, GroupType groupType) {
            GroupType repeatedType = groupType.getType(0).asGroupType();
            this.repeatedGroupName = repeatedType.getName();
            Type elementType = repeatedType.getType(0);
            this.elementName = elementType.getName();
            this.elementWriter = ParquetRowDataWriter.this.createWriter(t, elementType);
        }

        @Override
        public void write(InternalRow row, int ordinal) {
            this.writeArrayData(row.getArray(ordinal));
        }

        @Override
        public void write(InternalArray arrayData, int ordinal) {
            this.writeArrayData(arrayData.getArray(ordinal));
        }

        private void writeArrayData(InternalArray arrayData) {
            ParquetRowDataWriter.this.recordConsumer.startGroup();
            int listLength = arrayData.size();
            if (listLength > 0) {
                ParquetRowDataWriter.this.recordConsumer.startField(this.repeatedGroupName, 0);
                for (int i = 0; i < listLength; ++i) {
                    ParquetRowDataWriter.this.recordConsumer.startGroup();
                    if (!arrayData.isNullAt(i)) {
                        ParquetRowDataWriter.this.recordConsumer.startField(this.elementName, 0);
                        this.elementWriter.write(arrayData, i);
                        ParquetRowDataWriter.this.recordConsumer.endField(this.elementName, 0);
                    }
                    ParquetRowDataWriter.this.recordConsumer.endGroup();
                }
                ParquetRowDataWriter.this.recordConsumer.endField(this.repeatedGroupName, 0);
            }
            ParquetRowDataWriter.this.recordConsumer.endGroup();
        }
    }

    private class MapWriter
    implements FieldWriter {
        private final String repeatedGroupName;
        private final String keyName;
        private final String valueName;
        private final FieldWriter keyWriter;
        private final FieldWriter valueWriter;

        private MapWriter(DataType keyType, DataType valueType, GroupType groupType) {
            GroupType repeatedType = groupType.getType(0).asGroupType();
            this.repeatedGroupName = repeatedType.getName();
            Type type = repeatedType.getType(0);
            this.keyName = type.getName();
            this.keyWriter = ParquetRowDataWriter.this.createWriter(keyType, type);
            Type valuetype = repeatedType.getType(1);
            this.valueName = valuetype.getName();
            this.valueWriter = ParquetRowDataWriter.this.createWriter(valueType, valuetype);
        }

        @Override
        public void write(InternalRow row, int ordinal) {
            this.writeMapData(row.getMap(ordinal));
        }

        @Override
        public void write(InternalArray arrayData, int ordinal) {
            this.writeMapData(arrayData.getMap(ordinal));
        }

        private void writeMapData(InternalMap mapData) {
            ParquetRowDataWriter.this.recordConsumer.startGroup();
            if (mapData != null && mapData.size() > 0) {
                ParquetRowDataWriter.this.recordConsumer.startField(this.repeatedGroupName, 0);
                InternalArray keyArray = mapData.keyArray();
                InternalArray valueArray = mapData.valueArray();
                for (int i = 0; i < keyArray.size(); ++i) {
                    ParquetRowDataWriter.this.recordConsumer.startGroup();
                    if (keyArray.isNullAt(i)) {
                        throw new IllegalArgumentException("Parquet does not support null keys in maps. See https://github.com/apache/parquet-format/blob/master/LogicalTypes.md#maps for more details.");
                    }
                    ParquetRowDataWriter.this.recordConsumer.startField(this.keyName, 0);
                    this.keyWriter.write(keyArray, i);
                    ParquetRowDataWriter.this.recordConsumer.endField(this.keyName, 0);
                    if (!valueArray.isNullAt(i)) {
                        ParquetRowDataWriter.this.recordConsumer.startField(this.valueName, 1);
                        this.valueWriter.write(valueArray, i);
                        ParquetRowDataWriter.this.recordConsumer.endField(this.valueName, 1);
                    }
                    ParquetRowDataWriter.this.recordConsumer.endGroup();
                }
                ParquetRowDataWriter.this.recordConsumer.endField(this.repeatedGroupName, 0);
            }
            ParquetRowDataWriter.this.recordConsumer.endGroup();
        }
    }

    private class TimestampInt96Writer
    implements FieldWriter {
        private final int precision;

        private TimestampInt96Writer(int precision) {
            Preconditions.checkArgument(precision > 6);
            this.precision = precision;
        }

        @Override
        public void write(InternalRow row, int ordinal) {
            this.writeTimestamp(row.getTimestamp(ordinal, this.precision));
        }

        @Override
        public void write(InternalArray arrayData, int ordinal) {
            this.writeTimestamp(arrayData.getTimestamp(ordinal, this.precision));
        }

        private void writeTimestamp(Timestamp value) {
            ParquetRowDataWriter.this.recordConsumer.addBinary(ParquetRowDataWriter.this.timestampToInt96(value));
        }
    }

    private class TimestampMicrosWriter
    implements FieldWriter {
        private final int precision;

        private TimestampMicrosWriter(int precision) {
            Preconditions.checkArgument(precision > 3);
            Preconditions.checkArgument(precision <= 6);
            this.precision = precision;
        }

        @Override
        public void write(InternalRow row, int ordinal) {
            this.writeTimestamp(row.getTimestamp(ordinal, this.precision));
        }

        @Override
        public void write(InternalArray arrayData, int ordinal) {
            this.writeTimestamp(arrayData.getTimestamp(ordinal, this.precision));
        }

        private void writeTimestamp(Timestamp value) {
            ParquetRowDataWriter.this.recordConsumer.addLong(value.toMicros());
        }
    }

    private class TimestampMillsWriter
    implements FieldWriter {
        private final int precision;

        private TimestampMillsWriter(int precision) {
            Preconditions.checkArgument(precision <= 3);
            this.precision = precision;
        }

        @Override
        public void write(InternalRow row, int ordinal) {
            this.writeTimestamp(row.getTimestamp(ordinal, this.precision));
        }

        @Override
        public void write(InternalArray arrayData, int ordinal) {
            this.writeTimestamp(arrayData.getTimestamp(ordinal, this.precision));
        }

        private void writeTimestamp(Timestamp value) {
            ParquetRowDataWriter.this.recordConsumer.addLong(value.getMillisecond());
        }
    }

    private class IntWriter
    implements FieldWriter {
        private IntWriter() {
        }

        @Override
        public void write(InternalRow row, int ordinal) {
            this.writeInt(row.getInt(ordinal));
        }

        @Override
        public void write(InternalArray arrayData, int ordinal) {
            this.writeInt(arrayData.getInt(ordinal));
        }

        private void writeInt(int value) {
            ParquetRowDataWriter.this.recordConsumer.addInteger(value);
        }
    }

    private class BinaryWriter
    implements FieldWriter {
        private BinaryWriter() {
        }

        @Override
        public void write(InternalRow row, int ordinal) {
            this.writeBinary(row.getBinary(ordinal));
        }

        @Override
        public void write(InternalArray arrayData, int ordinal) {
            this.writeBinary(arrayData.getBinary(ordinal));
        }

        private void writeBinary(byte[] value) {
            ParquetRowDataWriter.this.recordConsumer.addBinary(Binary.fromReusedByteArray(value));
        }
    }

    private class StringWriter
    implements FieldWriter {
        private StringWriter() {
        }

        @Override
        public void write(InternalRow row, int ordinal) {
            this.writeString(row.getString(ordinal));
        }

        @Override
        public void write(InternalArray arrayData, int ordinal) {
            this.writeString(arrayData.getString(ordinal));
        }

        private void writeString(BinaryString value) {
            ParquetRowDataWriter.this.recordConsumer.addBinary(Binary.fromReusedByteArray(value.toBytes()));
        }
    }

    private class DoubleWriter
    implements FieldWriter {
        private DoubleWriter() {
        }

        @Override
        public void write(InternalRow row, int ordinal) {
            this.writeDouble(row.getDouble(ordinal));
        }

        @Override
        public void write(InternalArray arrayData, int ordinal) {
            this.writeDouble(arrayData.getDouble(ordinal));
        }

        private void writeDouble(double value) {
            ParquetRowDataWriter.this.recordConsumer.addDouble(value);
        }
    }

    private class FloatWriter
    implements FieldWriter {
        private FloatWriter() {
        }

        @Override
        public void write(InternalRow row, int ordinal) {
            this.writeFloat(row.getFloat(ordinal));
        }

        @Override
        public void write(InternalArray arrayData, int ordinal) {
            this.writeFloat(arrayData.getFloat(ordinal));
        }

        private void writeFloat(float value) {
            ParquetRowDataWriter.this.recordConsumer.addFloat(value);
        }
    }

    private class LongWriter
    implements FieldWriter {
        private LongWriter() {
        }

        @Override
        public void write(InternalRow row, int ordinal) {
            this.writeLong(row.getLong(ordinal));
        }

        @Override
        public void write(InternalArray arrayData, int ordinal) {
            this.writeLong(arrayData.getLong(ordinal));
        }

        private void writeLong(long value) {
            ParquetRowDataWriter.this.recordConsumer.addLong(value);
        }
    }

    private class ShortWriter
    implements FieldWriter {
        private ShortWriter() {
        }

        @Override
        public void write(InternalRow row, int ordinal) {
            this.writeShort(row.getShort(ordinal));
        }

        @Override
        public void write(InternalArray arrayData, int ordinal) {
            this.writeShort(arrayData.getShort(ordinal));
        }

        private void writeShort(short value) {
            ParquetRowDataWriter.this.recordConsumer.addInteger(value);
        }
    }

    private class ByteWriter
    implements FieldWriter {
        private ByteWriter() {
        }

        @Override
        public void write(InternalRow row, int ordinal) {
            this.writeByte(row.getByte(ordinal));
        }

        @Override
        public void write(InternalArray arrayData, int ordinal) {
            this.writeByte(arrayData.getByte(ordinal));
        }

        private void writeByte(byte value) {
            ParquetRowDataWriter.this.recordConsumer.addInteger(value);
        }
    }

    private class BooleanWriter
    implements FieldWriter {
        private BooleanWriter() {
        }

        @Override
        public void write(InternalRow row, int ordinal) {
            this.writeBoolean(row.getBoolean(ordinal));
        }

        @Override
        public void write(InternalArray arrayData, int ordinal) {
            this.writeBoolean(arrayData.getBoolean(ordinal));
        }

        private void writeBoolean(boolean value) {
            ParquetRowDataWriter.this.recordConsumer.addBoolean(value);
        }
    }

    private static interface FieldWriter {
        public void write(InternalRow var1, int var2);

        public void write(InternalArray var1, int var2);
    }
}

