/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet.reader;

import java.io.IOException;
import java.util.List;
import org.apache.paimon.data.columnar.heap.HeapRowVector;
import org.apache.paimon.data.columnar.writable.WritableColumnVector;
import org.apache.paimon.format.parquet.reader.ColumnReader;

public class RowColumnReader
implements ColumnReader<WritableColumnVector> {
    private final List<ColumnReader> fieldReaders;

    public RowColumnReader(List<ColumnReader> fieldReaders) {
        this.fieldReaders = fieldReaders;
    }

    @Override
    public void readToVector(int readNumber, WritableColumnVector vector) throws IOException {
        HeapRowVector rowVector = (HeapRowVector)vector;
        WritableColumnVector[] vectors = rowVector.getFields();
        boolean[] isNulls = new boolean[readNumber];
        for (int i = 0; i < vectors.length; ++i) {
            this.fieldReaders.get(i).readToVector(readNumber, vectors[i]);
            for (int j = 0; j < readNumber; ++j) {
                if (i == 0) {
                    isNulls[j] = vectors[i].isNullAt(j);
                } else {
                    boolean bl = isNulls[j] = isNulls[j] && vectors[i].isNullAt(j);
                }
                if (i != vectors.length - 1 || !isNulls[j]) continue;
                rowVector.setNullAt(j);
            }
        }
    }
}

